/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.service.EruptSessionService;

@Service
public class EruptContextService {
    @Resource
    private HttpServletRequest request;
    @Resource
    private EruptSessionService sessionService;

    private String getEruptHeader() {
        String erupt = this.request.getHeader("erupt");
        if (StringUtils.isBlank((CharSequence)erupt)) {
            erupt = this.request.getParameter("_erupt");
        }
        Assert.notNull((Object)erupt, (String)"request header 'erupt' not found ");
        return erupt;
    }

    public EruptMenu getCurrentEruptMenu() {
        return this.sessionService.getMapValue("eruptAuth:menu-value-map:" + this.getCurrentToken(), this.getEruptHeader(), EruptMenu.class);
    }

    public Class<?> getContextEruptClass() {
        return EruptCoreService.getErupt((String)this.getEruptHeader()).getClazz();
    }

    public String getCurrentToken() {
        String token = this.request.getHeader("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            return this.request.getParameter("_token");
        }
        return token;
    }
}

