/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public class MD5Utils {
    private static final String[] STR_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private MD5Utils() {
    }

    private static String byteToArrayString(byte bByte) {
        int iRet = bByte;
        if (iRet < 0) {
            iRet += 256;
        }
        int iD1 = iRet / 16;
        int iD2 = iRet % 16;
        return STR_DIGITS[iD1] + STR_DIGITS[iD2];
    }

    private static String byteToString(byte[] bByte) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bByte) {
            sb.append(MD5Utils.byteToArrayString(b));
        }
        return sb.toString();
    }

    public static String digest(String strObj) {
        return MD5Utils.digest(strObj, StandardCharsets.UTF_8.name());
    }

    public static String digest(String strObj, String charset) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return MD5Utils.byteToString(md.digest(strObj.getBytes(charset)));
        }
        catch (Exception ex) {
            return strObj;
        }
    }

    public static String digestSalt(String strObj, String salt) {
        strObj = MD5Utils.digest(strObj);
        strObj = strObj + salt;
        return MD5Utils.digest(strObj);
    }
}

