/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.model;

import java.util.Date;
import java.util.Set;
import javax.annotation.Resource;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.sub_erupt.LinkTree;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.BoolType;
import xyz.erupt.annotation.sub_field.sub_edit.InputType;
import xyz.erupt.annotation.sub_field.sub_edit.ReferenceTreeType;
import xyz.erupt.annotation.sub_field.sub_edit.Search;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptOrg;
import xyz.erupt.upms.model.EruptPost;
import xyz.erupt.upms.model.EruptRole;
import xyz.erupt.upms.model.base.HyperModel;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.util.MD5Utils;

@Entity
@Table(name="e_upms_user", uniqueConstraints={@UniqueConstraint(columnNames={"account"})})
@Erupt(name="\u7528\u6237", desc="\u7528\u6237\u914d\u7f6e", dataProxy={EruptUser.class}, linkTree=@LinkTree(field="eruptOrg"))
@Component
public class EruptUser
extends HyperModel
implements DataProxy<EruptUser> {
    private static final String EMAIL_REGEX = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    private static final String PHONE_REGEX = "^[1][3,4,5,6,7,8,9][0-9]{9}$";
    @EruptField(views={@View(title="\u7528\u6237\u540d", sortable=true)}, edit=@Edit(title="\u7528\u6237\u540d", desc="\u767b\u5f55\u7528\u6237\u540d", notNull=true, search=@Search(vague=true)))
    private String account;
    @EruptField(views={@View(title="\u59d3\u540d", sortable=true)}, edit=@Edit(title="\u59d3\u540d", notNull=true, search=@Search(vague=true)))
    private String name;
    @EruptField(views={@View(title="\u8d26\u6237\u72b6\u6001")}, edit=@Edit(title="\u8d26\u6237\u72b6\u6001", search=@Search, type=EditType.BOOLEAN, notNull=true, boolType=@BoolType(trueText="\u6fc0\u6d3b", falseText="\u9501\u5b9a")))
    private Boolean status = true;
    @EruptField(views={@View(title="\u624b\u673a\u53f7\u7801")}, edit=@Edit(title="\u624b\u673a\u53f7\u7801", search=@Search(vague=true), inputType=@InputType(regex="^[1][3,4,5,6,7,8,9][0-9]{9}$")))
    private String phone;
    @EruptField(views={@View(title="\u90ae\u7bb1")}, edit=@Edit(title="\u90ae\u7bb1", search=@Search(vague=true), inputType=@InputType(regex="^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$")))
    private String email;
    @ManyToOne
    @EruptField(views={@View(title="\u9996\u9875\u5730\u5740", column="name")}, edit=@Edit(title="\u9996\u9875\u5730\u5740", type=EditType.REFERENCE_TREE, referenceTreeType=@ReferenceTreeType(pid="parentMenu.id")))
    private EruptMenu eruptMenu;
    @ManyToOne
    @EruptField(views={@View(title="\u6240\u5c5e\u7ec4\u7ec7", column="name")}, edit=@Edit(title="\u6240\u5c5e\u7ec4\u7ec7", type=EditType.REFERENCE_TREE, referenceTreeType=@ReferenceTreeType(pid="parentOrg.id")))
    private EruptOrg eruptOrg;
    @ManyToOne
    @EruptField(views={@View(title="\u5c97\u4f4d", column="name")}, edit=@Edit(title="\u5c97\u4f4d", type=EditType.REFERENCE_TREE))
    private EruptPost eruptPost;
    @Transient
    @EruptField(edit=@Edit(title="\u5bc6\u7801", type=EditType.DIVIDE))
    private String pwdDivide;
    private String password;
    @Transient
    @EruptField(edit=@Edit(title="\u5bc6\u7801"))
    private String passwordA;
    @Transient
    @EruptField(edit=@Edit(title="\u786e\u8ba4\u5bc6\u7801"))
    private String passwordB;
    @EruptField(views={@View(title="md5\u52a0\u5bc6")}, edit=@Edit(title="md5\u52a0\u5bc6", type=EditType.BOOLEAN, notNull=true, boolType=@BoolType(trueText="\u52a0\u5bc6", falseText="\u4e0d\u52a0\u5bc6")))
    private Boolean isMd5 = true;
    @ManyToMany
    @JoinTable(name="e_upms_user_role", joinColumns={@JoinColumn(name="user_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="role_id", referencedColumnName="id")})
    @EruptField(views={@View(title="\u6240\u5c5e\u89d2\u8272")}, edit=@Edit(title="\u6240\u5c5e\u89d2\u8272", type=EditType.CHECKBOX))
    private Set<EruptRole> roles;
    @Column(length=2000)
    @EruptField(edit=@Edit(title="ip\u767d\u540d\u5355", desc="ip\u4e0eip\u4e4b\u95f4\u4f7f\u7528\u6362\u884c\u7b26\u95f4\u9694\uff0c\u4e0d\u586b\u8868\u793a\u4e0d\u9274\u6743", type=EditType.TEXTAREA))
    private String whiteIp;
    @Column(length=2000)
    @EruptField(edit=@Edit(title="\u5907\u6ce8", type=EditType.TEXTAREA))
    private String remark;
    private Boolean isAdmin;
    @Transient
    @PersistenceContext
    private EntityManager entityManager;
    @Transient
    @Resource
    private EruptUserService eruptUserService;

    public EruptUser() {
    }

    public EruptUser(Long id) {
        this.setId(id);
    }

    public void beforeAdd(EruptUser eruptUser) {
        if (StringUtils.isBlank((CharSequence)eruptUser.getPasswordA())) {
            throw new EruptApiErrorTip(EruptApiModel.Status.WARNING, "\u5bc6\u7801\u5fc5\u586b", EruptApiModel.PromptWay.MESSAGE);
        }
        this.checkPostOrg(eruptUser);
        if (eruptUser.getPasswordA().equals(eruptUser.getPasswordB())) {
            eruptUser.setIsAdmin(false);
            eruptUser.setCreateTime(new Date());
            if (eruptUser.getIsMd5().booleanValue()) {
                eruptUser.setPassword(MD5Utils.digest(eruptUser.getPasswordA()));
            }
        } else {
            throw new EruptWebApiRuntimeException("\u4e24\u6b21\u5bc6\u7801\u8f93\u5165\u4e0d\u4e00\u81f4");
        }
    }

    public void beforeUpdate(EruptUser eruptUser) {
        this.entityManager.clear();
        EruptUser eu = (EruptUser)((Object)this.entityManager.find(EruptUser.class, (Object)eruptUser.getId()));
        if (!eruptUser.getIsMd5().booleanValue() && eu.getIsMd5().booleanValue()) {
            throw new EruptWebApiRuntimeException("MD5 \u4e0d\u53ef\u9006");
        }
        this.checkPostOrg(eruptUser);
        if (StringUtils.isNotBlank((CharSequence)eruptUser.getPasswordA())) {
            if (!eruptUser.getPasswordA().equals(eruptUser.getPasswordB())) {
                throw new EruptWebApiRuntimeException("\u4e24\u6b21\u5bc6\u7801\u8f93\u5165\u4e0d\u4e00\u81f4");
            }
            if (eruptUser.getIsMd5().booleanValue()) {
                eruptUser.setPassword(MD5Utils.digest(eruptUser.getPasswordA()));
            } else {
                eruptUser.setPassword(eruptUser.getPasswordA());
            }
        }
    }

    private void checkPostOrg(EruptUser eruptUser) {
        if (eruptUser.getEruptPost() != null && eruptUser.getEruptOrg() == null) {
            throw new EruptWebApiRuntimeException("\u9009\u62e9\u5c97\u4f4d\u65f6\uff0c\u6240\u5c5e\u7ec4\u7ec7\u5fc5\u586b");
        }
    }

    public String getAccount() {
        return this.account;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmail() {
        return this.email;
    }

    public EruptMenu getEruptMenu() {
        return this.eruptMenu;
    }

    public EruptOrg getEruptOrg() {
        return this.eruptOrg;
    }

    public EruptPost getEruptPost() {
        return this.eruptPost;
    }

    public String getPwdDivide() {
        return this.pwdDivide;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordA() {
        return this.passwordA;
    }

    public String getPasswordB() {
        return this.passwordB;
    }

    public Boolean getIsMd5() {
        return this.isMd5;
    }

    public Set<EruptRole> getRoles() {
        return this.roles;
    }

    public String getWhiteIp() {
        return this.whiteIp;
    }

    public String getRemark() {
        return this.remark;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public EruptUserService getEruptUserService() {
        return this.eruptUserService;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEruptMenu(EruptMenu eruptMenu) {
        this.eruptMenu = eruptMenu;
    }

    public void setEruptOrg(EruptOrg eruptOrg) {
        this.eruptOrg = eruptOrg;
    }

    public void setEruptPost(EruptPost eruptPost) {
        this.eruptPost = eruptPost;
    }

    public void setPwdDivide(String pwdDivide) {
        this.pwdDivide = pwdDivide;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordA(String passwordA) {
        this.passwordA = passwordA;
    }

    public void setPasswordB(String passwordB) {
        this.passwordB = passwordB;
    }

    public void setIsMd5(Boolean isMd5) {
        this.isMd5 = isMd5;
    }

    public void setRoles(Set<EruptRole> roles) {
        this.roles = roles;
    }

    public void setWhiteIp(String whiteIp) {
        this.whiteIp = whiteIp;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setEruptUserService(EruptUserService eruptUserService) {
        this.eruptUserService = eruptUserService;
    }
}

