/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.handler;

import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.fun.ChoiceFetchHandler;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.upms.cache.CaffeineEruptCache;

@Component
public class SqlChoiceFetchHandler
implements ChoiceFetchHandler {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private final String CACHE_SPACE = SqlChoiceFetchHandler.class.getName() + ":";
    private final CaffeineEruptCache<List<VLModel>> sqlCache = new CaffeineEruptCache();

    public List<VLModel> fetch(String[] params) {
        if (null == params || params.length == 0) {
            throw new RuntimeException("SqlChoiceFetchHandler \u2192 params not found");
        }
        long timeout = 3000L;
        if (params.length == 2) {
            timeout = Long.parseLong(params[1]);
        }
        this.sqlCache.init(timeout);
        return this.sqlCache.get(this.CACHE_SPACE + params[0], key -> this.jdbcTemplate.query(params[0], (rs, i) -> {
            if (rs.getMetaData().getColumnCount() == 1) {
                return new VLModel(rs.getString(1), rs.getString(1));
            }
            return new VLModel(rs.getString(1), rs.getString(2));
        }));
    }
}

