/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.EpollRecvByteAllocatorMessageHandle;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.Socket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class AbstractEpollServerChannel
extends AbstractEpollChannel
implements ServerChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);

    protected AbstractEpollServerChannel(int fd) {
        this(new Socket(fd), false);
    }

    @Deprecated
    protected AbstractEpollServerChannel(FileDescriptor fd) {
        this(new Socket(fd.intValue()));
    }

    @Deprecated
    protected AbstractEpollServerChannel(Socket fd) {
        this(fd, fd.getSoError() == 0);
    }

    protected AbstractEpollServerChannel(Socket fd, boolean active) {
        super(null, fd, Native.EPOLLIN, active);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EpollEventLoop;
    }

    protected InetSocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollServerSocketUnsafe();
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Object filterOutboundMessage(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    abstract Channel newChildChannel(int var1, byte[] var2, int var3, int var4) throws Exception;

    final class EpollServerSocketUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        private final byte[] acceptedAddress;

        EpollServerSocketUnsafe() {
            super(AbstractEpollServerChannel.this);
            this.acceptedAddress = new byte[26];
        }

        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            channelPromise.setFailure((Throwable)new UnsupportedOperationException());
        }

        @Override
        protected EpollRecvByteAllocatorHandle newEpollHandle(RecvByteBufAllocator.Handle handle) {
            return new EpollRecvByteAllocatorMessageHandle(handle, AbstractEpollServerChannel.this.isFlagSet(Native.EPOLLET));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            assert (AbstractEpollServerChannel.this.eventLoop().inEventLoop());
            if (AbstractEpollServerChannel.this.fd().isInputShutdown()) {
                return;
            }
            boolean edgeTriggered = AbstractEpollServerChannel.this.isFlagSet(Native.EPOLLET);
            EpollChannelConfig config = AbstractEpollServerChannel.this.config();
            if (!(this.readPending || edgeTriggered || config.isAutoRead())) {
                this.clearEpollIn0();
                return;
            }
            ChannelPipeline pipeline = AbstractEpollServerChannel.this.pipeline();
            EpollRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            allocHandle.reset((ChannelConfig)config);
            Throwable exception = null;
            try {
                try {
                    int socketFd;
                    while ((socketFd = AbstractEpollServerChannel.this.fd().accept(this.acceptedAddress)) != -1) {
                        this.readPending = false;
                        allocHandle.incMessagesRead(1);
                        byte len = this.acceptedAddress[0];
                        pipeline.fireChannelRead((Object)AbstractEpollServerChannel.this.newChildChannel(socketFd, this.acceptedAddress, 1, len));
                        if (allocHandle.continueReading()) continue;
                        break;
                    }
                }
                catch (Throwable t) {
                    exception = t;
                }
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                if (exception != null) {
                    pipeline.fireExceptionCaught(exception);
                    this.checkResetEpollIn(edgeTriggered);
                }
            }
            finally {
                if (!this.readPending && !config.isAutoRead()) {
                    this.clearEpollIn0();
                }
            }
        }
    }
}

