/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util.function;

import java.util.function.BiFunction;

public interface ThrowingBiFunction<T, U, R>
extends BiFunction<T, U, R> {
    public R applyWithException(T var1, U var2) throws Exception;

    @Override
    default public R apply(T t, U u) {
        return this.apply(t, u, RuntimeException::new);
    }

    default public R apply(T t, U u, BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        try {
            return this.applyWithException(t, u);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw exceptionWrapper.apply(ex.getMessage(), ex);
        }
    }

    default public ThrowingBiFunction<T, U, R> throwing(final BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        return new ThrowingBiFunction<T, U, R>(){

            @Override
            public R applyWithException(T t, U u) throws Exception {
                return ThrowingBiFunction.this.applyWithException(t, u);
            }

            @Override
            public R apply(T t, U u) {
                return this.apply(t, u, exceptionWrapper);
            }
        };
    }

    public static <T, U, R> ThrowingBiFunction<T, U, R> of(ThrowingBiFunction<T, U, R> function) {
        return function;
    }

    public static <T, U, R> ThrowingBiFunction<T, U, R> of(ThrowingBiFunction<T, U, R> function, BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        return function.throwing(exceptionWrapper);
    }
}

