/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StreamUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;

public abstract class StringUtils {
    public static final String TOP_PATH = "..";
    public static final String CURRENT_PATH = ".";
    public static final char FOLDER_SEPARATOR_CHAR = '/';
    public static final String FOLDER_SEPARATOR = "/";
    public static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    public static final char EXTENSION_SEPARATOR = '.';
    private static final Random random = new Random();

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringUtils.isEmpty(str);
    }

    public static String[] split(String source) {
        if (source == null) {
            return Constant.EMPTY_STRING_ARRAY;
        }
        return StringUtils.toStringArray(StringUtils.splitAsList(source));
    }

    public static List<String> splitAsList(String source) {
        char[] chars;
        if (source == null) {
            return Collections.emptyList();
        }
        if (source.isEmpty()) {
            return Collections.singletonList(source);
        }
        ArrayList<String> splitList = new ArrayList<String>();
        int idx = 0;
        int start = 0;
        for (char c : chars = source.toCharArray()) {
            if (StringUtils.isSplitable(c)) {
                splitList.add(new String(chars, start, idx - start));
                start = idx + 1;
            }
            ++idx;
        }
        if (idx != start && idx == source.length()) {
            splitList.add(new String(chars, start, idx - start));
        } else if (splitList.isEmpty()) {
            return Collections.singletonList(source);
        }
        return splitList;
    }

    private static boolean isSplitable(char c) {
        return c == ',' || c == ';';
    }

    @Nullable
    public static String[] split(@Nullable String toSplit, @Nullable String delimiter) {
        if (StringUtils.isEmpty(toSplit) || StringUtils.isEmpty(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static String uriDecode(String source, Charset charset) {
        int length = source.length();
        if (length == 0) {
            return source;
        }
        Assert.notNull((Object)charset, "Charset must not be null");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    baos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            baos.write(ch);
        }
        return changed ? StreamUtils.copyToString(baos, charset) : source;
    }

    @Nullable
    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter) {
        return StringUtils.splitArrayElementsIntoProperties(array, delimiter, null);
    }

    @Nullable
    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter, @Nullable String charsToDelete) {
        if (ObjectUtils.isEmpty(array)) {
            return null;
        }
        Properties result = new Properties();
        for (String element : array) {
            String[] splittedElement;
            if (charsToDelete != null) {
                element = StringUtils.deleteAny(element, charsToDelete);
            }
            if ((splittedElement = StringUtils.split(element, delimiter)) == null) continue;
            result.setProperty(splittedElement[0].trim(), splittedElement[1].trim());
        }
        return result;
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return Constant.EMPTY_STRING_ARRAY;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(@Nullable Collection<String> collection) {
        if (collection == null) {
            return Constant.EMPTY_STRING_ARRAY;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] toStringArray(@Nullable Enumeration<String> enumeration) {
        return enumeration == null ? Constant.EMPTY_STRING_ARRAY : StringUtils.toStringArray(Collections.list(enumeration));
    }

    public static String[] addStringToArray(@Nullable String[] array, String str) {
        if (ObjectUtils.isEmpty(array)) {
            return new String[]{str};
        }
        String[] newArr = new String[array.length + 1];
        System.arraycopy(array, 0, newArr, 0, array.length);
        newArr[array.length] = str;
        return newArr;
    }

    public static String[] sortArray(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return array;
        }
        Arrays.sort(array);
        return array;
    }

    public static String[] trimArrayElements(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return array;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String element = array[i];
            result[i] = element != null ? element.trim() : null;
        }
        return result;
    }

    public static String[] removeDuplicateStrings(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return array;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        CollectionUtils.addAll(set, (Object[])array);
        return StringUtils.toStringArray(set);
    }

    public static String arrayToDelimitedString(@Nullable Object[] arr, String delim) {
        if (ObjectUtils.isEmpty(arr)) {
            return "";
        }
        if (arr.length == 1) {
            return ObjectUtils.nullSafeToString(arr[0]);
        }
        StringJoiner sj = new StringJoiner(delim);
        for (Object elem : arr) {
            sj.add(String.valueOf(elem));
        }
        return sj.toString();
    }

    public static String arrayToCommaDelimitedString(@Nullable Object[] arr) {
        return StringUtils.arrayToDelimitedString(arr, ",");
    }

    public static String collectionToDelimitedString(@Nullable Collection<?> coll, String delim, String prefix, String suffix) {
        if (CollectionUtils.isEmpty(coll)) {
            return "";
        }
        int totalLength = coll.size() * (prefix.length() + suffix.length()) + (coll.size() - 1) * delim.length();
        for (Object element : coll) {
            totalLength += String.valueOf(element).length();
        }
        StringBuilder sb = new StringBuilder(totalLength);
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(@Nullable Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(@Nullable Collection<?> coll) {
        return StringUtils.collectionToDelimitedString(coll, ",");
    }

    public static Set<String> commaDelimitedListToSet(@Nullable String str) {
        String[] tokens = StringUtils.commaDelimitedListToStringArray(str);
        return new LinkedHashSet<String>(Arrays.asList(tokens));
    }

    public static String getUUIDString() {
        return UUID.randomUUID().toString();
    }

    public static String cleanPath(String path) {
        int i;
        if (StringUtils.isEmpty(path)) {
            return path;
        }
        String pathToUse = StringUtils.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        if (pathToUse.indexOf(46) == -1) {
            return pathToUse;
        }
        int prefixIndex = pathToUse.indexOf(58);
        Object prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (((String)prefix).contains(FOLDER_SEPARATOR)) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (StringUtils.matchesFirst(pathToUse, '/')) {
            prefix = (String)prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (CURRENT_PATH.equals(element)) continue;
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (pathArray.length == pathElements.size()) {
            return ((String)prefix).concat(pathToUse);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        if (pathElements.size() == 1 && "".equals(pathElements.getLast()) && !((String)prefix).endsWith(FOLDER_SEPARATOR)) {
            pathElements.add(0, CURRENT_PATH);
        }
        return ((String)prefix).concat(StringUtils.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR));
    }

    public static boolean pathEquals(String path1, String path2) {
        return StringUtils.cleanPath(path1).equals(StringUtils.cleanPath(path2));
    }

    public static String formatURL(String url) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        if (url.charAt(0) == '/') {
            return url;
        }
        return FOLDER_SEPARATOR + url;
    }

    public static void appendLine(BufferedReader reader, StringBuilder builder) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String delete(String inString, String pattern) {
        return StringUtils.replace(inString, pattern, "");
    }

    public static String replace(String inString, String oldPattern, @Nullable String newPattern) {
        if (StringUtils.isEmpty(inString) || StringUtils.isEmpty(oldPattern) || newPattern == null) {
            return inString;
        }
        int index = inString.indexOf(oldPattern);
        if (index == -1) {
            return inString;
        }
        int capacity = inString.length();
        if (newPattern.length() > oldPattern.length()) {
            capacity += 16;
        }
        StringBuilder sb = new StringBuilder(capacity);
        int pos = 0;
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString, pos, index);
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString, pos, inString.length());
        return sb.toString();
    }

    @Nullable
    public static String quote(@Nullable String str) {
        return str != null ? "'" + str + "'" : null;
    }

    @Nullable
    public static Object quoteIfString(@Nullable Object obj) {
        return obj instanceof String ? StringUtils.quote((String)obj) : obj;
    }

    public static String unqualify(String qualifiedName) {
        return StringUtils.unqualify(qualifiedName, '.');
    }

    public static String unqualify(String qualifiedName, char separator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(separator) + 1);
    }

    public static String capitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, false);
    }

    public static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (capitalize ? firstChar >= 'A' && firstChar <= 'Z' : firstChar >= 'a' && firstChar <= 'z') {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = capitalize ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar);
        return new String(chars, 0, chars.length);
    }

    public static String deleteAny(String inString, @Nullable String charsToDelete) {
        if (StringUtils.isEmpty(inString) || StringUtils.isEmpty(charsToDelete)) {
            return inString;
        }
        int length = inString.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] commaDelimitedListToStringArray(@Nullable String str) {
        return StringUtils.delimitedListToStringArray(str, ",");
    }

    public static String[] delimitedListToStringArray(@Nullable String str, @Nullable String delimiter) {
        return StringUtils.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(@Nullable String str, @Nullable String delimiter, @Nullable String charsToDelete) {
        if (str == null) {
            return Constant.EMPTY_STRING_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        int length = str.length();
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            for (int i = 0; i < length; ++i) {
                result.add(StringUtils.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (length > 0 && pos <= length) {
                result.add(StringUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] concatenateStringArrays(String[] array1, String[] array2) {
        if (ObjectUtils.isEmpty(array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty(array2)) {
            return array1;
        }
        String[] newArr = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArr, 0, array1.length);
        System.arraycopy(array2, 0, newArr, array1.length, array2.length);
        return newArr;
    }

    public static boolean hasText(@Nullable CharSequence str) {
        return StringUtils.isNotEmpty(str) && StringUtils.containsText(str);
    }

    public static boolean hasText(@Nullable String str) {
        return str != null && !str.isEmpty() && StringUtils.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(47);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf(47);
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static String stripFilenameExtension(String path) {
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return path;
        }
        int folderIndex = path.lastIndexOf(47);
        if (folderIndex > extIndex) {
            return path;
        }
        return path.substring(0, extIndex);
    }

    public static boolean simpleMatch(String pattern, String str) {
        if (pattern == null || str == null) {
            return false;
        }
        int firstIndex = pattern.indexOf(42);
        if (firstIndex == -1) {
            return pattern.equals(str);
        }
        if (firstIndex == 0) {
            if (pattern.length() == 1) {
                return true;
            }
            int nextIndex = pattern.indexOf(42, 1);
            if (nextIndex == -1) {
                return str.endsWith(pattern.substring(1));
            }
            String part = pattern.substring(1, nextIndex);
            if (part.isEmpty()) {
                return StringUtils.simpleMatch(pattern.substring(nextIndex), str);
            }
            int partIndex = str.indexOf(part);
            while (partIndex != -1) {
                if (StringUtils.simpleMatch(pattern.substring(nextIndex), str.substring(partIndex + part.length()))) {
                    return true;
                }
                partIndex = str.indexOf(part, partIndex + 1);
            }
            return false;
        }
        return str.length() >= firstIndex && pattern.substring(0, firstIndex).equals(str.substring(0, firstIndex)) && StringUtils.simpleMatch(pattern.substring(firstIndex), str.substring(firstIndex));
    }

    public static boolean simpleMatch(@Nullable String[] patterns, String str) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!StringUtils.simpleMatch(pattern, str)) continue;
                return true;
            }
        }
        return false;
    }

    public static String generateRandomString(int length) {
        char[] ret = new char[length];
        Random random = StringUtils.random;
        for (int i = 0; i < length; ++i) {
            ret[i] = StringUtils.generateRandomCharacter(random.nextInt(3));
        }
        return String.valueOf(ret);
    }

    private static char generateRandomCharacter(int type) {
        switch (type) {
            case 0: {
                int rand = random.nextInt(26);
                return (char)(rand += 97);
            }
            case 1: {
                int rand = random.nextInt(26);
                return (char)(rand += 65);
            }
        }
        int rand = random.nextInt(10);
        return (char)(rand += 48);
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str) {
        return StringUtils.containsWhitespace((CharSequence)str);
    }

    public static String trimWhitespace(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.strip();
    }

    @Nullable
    public static String trimAllWhitespace(@Nullable String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.trimAllWhitespace((CharSequence)str).toString();
    }

    public static CharSequence trimAllWhitespace(CharSequence text) {
        if (StringUtils.isEmpty(text)) {
            return text;
        }
        int len = text.length();
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.stripLeading();
    }

    public static String trimTrailingWhitespace(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.stripTrailing();
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        int beginIdx;
        if (str == null || str.isEmpty()) {
            return str;
        }
        int length = str.length();
        for (beginIdx = 0; beginIdx < length && leadingCharacter == str.charAt(beginIdx); ++beginIdx) {
        }
        return str.substring(beginIdx);
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        int endIdx;
        if (str == null || str.isEmpty()) {
            return str;
        }
        for (endIdx = str.length() - 1; endIdx >= 0 && trailingCharacter == str.charAt(endIdx); --endIdx) {
        }
        return str.substring(0, endIdx + 1);
    }

    public static boolean startsWithIgnoreCase(@Nullable String str, @Nullable String prefix) {
        return str != null && prefix != null && str.length() >= prefix.length() && str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(@Nullable String str, @Nullable String suffix) {
        return str != null && suffix != null && str.length() >= suffix.length() && str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        int substringLength = substring.length();
        if (index + substringLength > str.length()) {
            return false;
        }
        for (int i = 0; i < substringLength; ++i) {
            if (str.charAt(index + i) == substring.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesCharacter(String str, char singleCharacter) {
        return str != null && str.length() == 1 && str.charAt(0) == singleCharacter;
    }

    public static boolean matchesCharacter(@Nullable String str, int idx, char charToMatch) {
        if (str == null || idx < 0 || idx >= str.length()) {
            return false;
        }
        return str.charAt(idx) == charToMatch;
    }

    public static boolean matchesFirst(@Nullable String str, char charToMatch) {
        return str != null && str.length() != 0 && str.charAt(0) == charToMatch;
    }

    public static boolean matchesLast(@Nullable String str, char charToMatch) {
        return StringUtils.isNotEmpty(str) && str.charAt(str.length() - 1) == charToMatch;
    }

    public static Locale parseLocale(String localeValue) {
        if (!localeValue.contains("_") && !localeValue.contains(" ")) {
            StringUtils.validateLocalePart(localeValue);
            Locale resolved = Locale.forLanguageTag(localeValue);
            if (resolved.getLanguage().length() > 0) {
                return resolved;
            }
        }
        return StringUtils.parseLocaleString(localeValue);
    }

    public static Locale parseLocaleString(String localeString) {
        String[] tokens;
        if (localeString.equals("")) {
            return null;
        }
        String delimiter = "_";
        if (!localeString.contains("_") && localeString.contains(" ")) {
            delimiter = " ";
        }
        if ((tokens = localeString.split(delimiter, -1)).length == 1) {
            String language = tokens[0];
            StringUtils.validateLocalePart(language);
            return new Locale(language);
        }
        if (tokens.length == 2) {
            String language = tokens[0];
            StringUtils.validateLocalePart(language);
            String country = tokens[1];
            StringUtils.validateLocalePart(country);
            return new Locale(language, country);
        }
        if (tokens.length > 2) {
            String language = tokens[0];
            StringUtils.validateLocalePart(language);
            String country = tokens[1];
            StringUtils.validateLocalePart(country);
            String variant = Arrays.stream(tokens).skip(2L).collect(Collectors.joining(delimiter));
            return new Locale(language, country, variant);
        }
        throw new IllegalArgumentException("Invalid locale format: '" + localeString + "'");
    }

    private static void validateLocalePart(String localePart) {
        int length = localePart.length();
        for (int i = 0; i < length; ++i) {
            char ch = localePart.charAt(i);
            if (ch == ' ' || ch == '_' || ch == '-' || ch == '#' || Character.isLetterOrDigit(ch)) continue;
            throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
        }
    }

    public static TimeZone parseTimeZoneString(String timeZoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        if ("GMT".equals(timeZone.getID()) && !timeZoneString.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + timeZoneString + "'");
        }
        return timeZone;
    }

    public static String camelCaseToUnderscore(String name) {
        if (StringUtils.isEmpty(name)) {
            return "";
        }
        int length = name.length();
        StringBuilder ret = new StringBuilder();
        ret.append(Character.toLowerCase(name.charAt(0)));
        for (int i = 1; i < length; ++i) {
            char c = name.charAt(i);
            if (c > '@' && c < '[') {
                ret.append('_').append((char)(c | 0x20));
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String underscoreToCamelCase(String underscore) {
        if (StringUtils.isEmpty(underscore)) {
            return underscore;
        }
        char[] chars = underscore.toCharArray();
        int write = -1;
        boolean upper = false;
        for (char c : chars) {
            if ('_' == c) {
                upper = true;
                continue;
            }
            if (upper) {
                upper = false;
                chars[++write] = Character.toUpperCase(c);
                continue;
            }
            chars[++write] = Character.toLowerCase(c);
        }
        return new String(chars, 0, ++write);
    }
}

