/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.lang.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class MapCache<Key, Value, Param> {
    private final Map<Key, Value> mapping;
    @Nullable
    private final Function<Key, Value> mappingFunction;

    public MapCache() {
        this(new HashMap());
    }

    public MapCache(int initialCapacity) {
        this(new HashMap(initialCapacity));
    }

    public MapCache(Map<Key, Value> mapping) {
        this.mapping = mapping;
        this.mappingFunction = null;
    }

    public MapCache(Function<Key, Value> mappingFunction) {
        this(new HashMap(), mappingFunction);
    }

    public MapCache(Map<Key, Value> mapping, @Nullable Function<Key, Value> mappingFunction) {
        this.mapping = mapping;
        this.mappingFunction = mappingFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Value get(Key key, Param param) {
        Value value = this.mapping.get(key);
        if (value == null) {
            Map<Key, Value> map = this.mapping;
            synchronized (map) {
                value = this.mapping.get(key);
                if (value == null) {
                    value = this.createValue(key, param);
                    this.mapping.put(key, value);
                }
            }
        }
        return value;
    }

    public final Value get(Key key) {
        return this.get(key, (Function)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Value get(Key key, @Nullable Function<Key, Value> mappingFunction) {
        Value value = this.mapping.get(key);
        if (value == null) {
            Map<Key, Value> map = this.mapping;
            synchronized (map) {
                value = this.mapping.get(key);
                if (value == null) {
                    if (mappingFunction == null) {
                        mappingFunction = this.mappingFunction;
                    }
                    if (mappingFunction != null) {
                        value = mappingFunction.apply(key);
                        this.mapping.put(key, value);
                    } else {
                        value = this.createValue(key, null);
                        this.mapping.put(key, value);
                    }
                }
            }
        }
        return value;
    }

    protected Value createValue(Key key, @Nullable Param param) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value put(Key key, Value value) {
        Map<Key, Value> map = this.mapping;
        synchronized (map) {
            return this.mapping.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Key, Value> map = this.mapping;
        synchronized (map) {
            this.mapping.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value remove(Key key) {
        Map<Key, Value> map = this.mapping;
        synchronized (map) {
            return this.mapping.remove(key);
        }
    }
}

