/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;

public abstract class ExceptionUtils {
    public static Throwable unwrapThrowable(Throwable ex) {
        Throwable unwrapped = ex;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static String buildMessage(String message, Throwable cause) {
        if (cause == null) {
            return message;
        }
        StringBuilder sb = new StringBuilder(64);
        if (message != null) {
            sb.append(message).append("; ");
        }
        sb.append("Nested exception is ");
        String nested = cause.getMessage();
        if (nested == null) {
            sb.append(cause);
        } else {
            sb.append(ExceptionUtils.buildMessage(cause.getMessage(), cause.getCause()));
        }
        return sb.toString();
    }

    public static Throwable getRootCause(Throwable original) {
        if (original == null) {
            return null;
        }
        Throwable rootCause = null;
        for (Throwable cause = original.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public static Throwable getMostSpecificCause(Throwable original) {
        Throwable rootCause = ExceptionUtils.getRootCause(original);
        return rootCause != null ? rootCause : original;
    }

    public static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        return (RuntimeException)ExceptionUtils.sneakyThrow0(t);
    }

    private static <T extends Throwable> T sneakyThrow0(Throwable t) throws T {
        throw t;
    }

    public static void sneakyThrow(Action action) {
        try {
            action.call();
        }
        catch (Throwable e) {
            throw ExceptionUtils.sneakyThrow(e);
        }
    }

    public static <T> T sneakyThrow(Callable<T> action) {
        try {
            return action.call();
        }
        catch (Exception e) {
            throw ExceptionUtils.sneakyThrow(e);
        }
    }

    public static interface Action {
        public void call() throws Throwable;
    }
}

