/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.core.ArraySizeTrimmer;
import cn.taketoday.core.DefaultMultiValueMap;
import cn.taketoday.core.MultiValueMap;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ArrayHolder;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.SingletonIterator;
import cn.taketoday.util.SortedProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class CollectionUtils {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final HashSet<Class<?>> approximableMapTypes = new HashSet();
    private static final HashSet<Class<?>> approximableCollectionTypes = new HashSet();

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isNotEmpty(@Nullable ArrayHolder<?> holder) {
        return holder != null && !holder.isEmpty();
    }

    public static boolean isEmpty(@Nullable ArrayHolder<?> holder) {
        return holder == null || holder.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Map<?, ?> map) {
        return !CollectionUtils.isEmpty(map);
    }

    public static boolean isCollection(Class<?> cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    @SafeVarargs
    public static <E> HashSet<E> newHashSet(E ... elements) {
        if (ObjectUtils.isNotEmpty(elements)) {
            HashSet ret = new HashSet(Math.max((int)((float)elements.length / 0.75f) + 1, 16));
            CollectionUtils.addAll(ret, (Object[])elements);
            return ret;
        }
        return new HashSet();
    }

    @SafeVarargs
    public static <E> LinkedHashSet<E> newLinkedHashSet(E ... elements) {
        if (ObjectUtils.isNotEmpty(elements)) {
            LinkedHashSet ret = new LinkedHashSet(Math.max((int)((float)elements.length / 0.75f) + 1, 16));
            CollectionUtils.addAll(ret, (Object[])elements);
            return ret;
        }
        return new LinkedHashSet();
    }

    @NonNull
    @SafeVarargs
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        if (ObjectUtils.isNotEmpty(elements)) {
            ArrayList ret = new ArrayList(elements.length);
            CollectionUtils.addAll(ret, (Object[])elements);
            return ret;
        }
        return new ArrayList();
    }

    public static boolean isApproximableCollectionType(@Nullable Class<?> collectionType) {
        return collectionType != null && approximableCollectionTypes.contains(collectionType);
    }

    public static <E> Collection<E> createApproximateCollection(Object collection, int capacity) {
        if (collection instanceof LinkedList) {
            return new LinkedList();
        }
        if (collection instanceof List) {
            return new ArrayList(capacity);
        }
        if (collection instanceof EnumSet) {
            EnumSet enumSet = EnumSet.copyOf((EnumSet)collection);
            enumSet.clear();
            return enumSet;
        }
        if (collection instanceof SortedSet) {
            return new TreeSet(((SortedSet)collection).comparator());
        }
        return new LinkedHashSet(capacity);
    }

    public static <E> Collection<E> createCollection(Class<?> collectionType) {
        return CollectionUtils.createCollection(collectionType, null, 0);
    }

    public static <E> Collection<E> createCollection(Class<?> collectionType, int capacity) {
        return CollectionUtils.createCollection(collectionType, null, capacity);
    }

    public static <E> Collection<E> createCollection(Class<?> collectionType, Class<?> elementType, int capacity) {
        Assert.notNull(collectionType, "Collection type must not be null");
        if (LinkedHashSet.class == collectionType || HashSet.class == collectionType || Set.class == collectionType || Collection.class == collectionType) {
            return new LinkedHashSet(capacity);
        }
        if (ArrayList.class == collectionType || List.class == collectionType) {
            return new ArrayList(capacity);
        }
        if (LinkedList.class == collectionType) {
            return new LinkedList();
        }
        if (TreeSet.class == collectionType || SortedSet.class == collectionType || NavigableSet.class == collectionType) {
            return new TreeSet();
        }
        if (EnumSet.class.isAssignableFrom(collectionType)) {
            Assert.notNull(elementType, "Cannot create EnumSet for unknown element type");
            return EnumSet.noneOf(CollectionUtils.asEnumType(elementType));
        }
        if (collectionType.isInterface() || !Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Unsupported Collection type: " + collectionType.getName());
        }
        try {
            return (Collection)ReflectionUtils.accessibleConstructor(collectionType, new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Could not instantiate Collection type: " + collectionType.getName(), ex);
        }
    }

    public static boolean isApproximableMapType(@Nullable Class<?> mapType) {
        return mapType != null && approximableMapTypes.contains(mapType);
    }

    public static <K, V> Map<K, V> createApproximateMap(@Nullable Object map) {
        return CollectionUtils.createApproximateMap(map, 0);
    }

    public static <K, V> Map<K, V> createApproximateMap(@Nullable Object map, int capacity) {
        if (map instanceof EnumMap) {
            EnumMap enumMap = new EnumMap((EnumMap)map);
            enumMap.clear();
            return enumMap;
        }
        if (map instanceof SortedMap) {
            return new TreeMap(((SortedMap)map).comparator());
        }
        return new LinkedHashMap(capacity);
    }

    public static <K, V> Map<K, V> createMap(@NonNull Class<?> mapType) {
        return CollectionUtils.createMap(mapType, null, 0);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType, int capacity) {
        return CollectionUtils.createMap(mapType, null, capacity);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType, Class<?> keyType, int capacity) {
        Assert.notNull(mapType, "Map type must not be null");
        if (mapType.isInterface()) {
            if (Map.class == mapType) {
                return new LinkedHashMap(capacity);
            }
            if (SortedMap.class == mapType || NavigableMap.class == mapType) {
                return new TreeMap();
            }
            if (MultiValueMap.class == mapType) {
                return new DefaultMultiValueMap();
            }
            throw new IllegalArgumentException("Unsupported Map interface: " + mapType.getName());
        }
        if (EnumMap.class == mapType) {
            Assert.notNull(keyType, "Cannot create EnumMap for unknown key type");
            return new EnumMap(CollectionUtils.asEnumType(keyType));
        }
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Unsupported Map type: " + mapType.getName());
        }
        try {
            return (Map)ReflectionUtils.accessibleConstructor(mapType, new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Could not instantiate Map type: " + mapType.getName(), ex);
        }
    }

    public static Properties createStringAdaptingProperties() {
        final class StringAdaptingProperties
        extends SortedProperties {
            private static final long serialVersionUID = 1L;

            StringAdaptingProperties() {
                super(false);
            }

            @Override
            public String getProperty(String key) {
                Object value = this.get(key);
                return value != null ? value.toString() : null;
            }
        }
        return new StringAdaptingProperties();
    }

    public static Properties createSortedProperties(boolean omitComments) {
        return new SortedProperties(omitComments);
    }

    public static Properties createSortedProperties(Properties properties, boolean omitComments) {
        return new SortedProperties(properties, omitComments);
    }

    private static Class<? extends Enum> asEnumType(Class<?> enumType) {
        Assert.notNull(enumType, "Enum type must not be null");
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new IllegalArgumentException("Supplied type is not an enum: " + enumType.getName());
        }
        return enumType.asSubclass(Enum.class);
    }

    public static void setValue(List list, int index, Object element) {
        int size = list.size();
        if (index >= size && index < Integer.MAX_VALUE) {
            for (int i = size; i < index; ++i) {
                list.add(null);
            }
            list.add(element);
        } else {
            list.set(index, element);
        }
    }

    @Nullable
    public static <T> T getElement(@Nullable List<T> list, int index) {
        if (list != null && index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return null;
    }

    @Nullable
    public static <T> T getElement(@Nullable T[] array, int index) {
        if (array != null && index >= 0 && index < array.length) {
            return array[index];
        }
        return null;
    }

    public static void addAll(Collection c, @Nullable Object[] elements) {
        if (elements != null) {
            for (Object element : elements) {
                c.add(element);
            }
        }
    }

    public static void addAll(Collection c, @Nullable Enumeration values) {
        if (values != null) {
            while (values.hasMoreElements()) {
                c.add(values.nextElement());
            }
        }
    }

    public static void addAll(Collection c, @Nullable Collection elements) {
        if (elements != null) {
            c.addAll(elements);
        }
    }

    public static void addAll(ArrayHolder c, @Nullable Object[] elements) {
        if (elements != null) {
            c.add(elements);
        }
    }

    public static void addAll(ArrayHolder c, @Nullable Collection elements) {
        if (elements != null) {
            c.addAll(elements);
        }
    }

    public static void putAll(Map target, @Nullable Map mappings) {
        if (mappings != null) {
            target.putAll(mappings);
        }
    }

    public static <T> void iterate(@Nullable Enumeration<T> enumeration, Consumer<T> consumer) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                consumer.accept(enumeration.nextElement());
            }
        }
    }

    public static <T> void iterate(@Nullable Iterator<T> iterator, Consumer<T> consumer) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                consumer.accept(iterator.next());
            }
        }
    }

    public static void trimToSize(@Nullable Object list) {
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        } else if (list instanceof ArraySizeTrimmer) {
            ArraySizeTrimmer sizeTrimmer = (ArraySizeTrimmer)list;
            sizeTrimmer.trimToSize();
        }
    }

    public static <K, V> void reverse(Map<K, V> source, Map<V, K> target) {
        for (Map.Entry<K, V> entry : source.entrySet()) {
            target.put(entry.getValue(), entry.getKey());
        }
    }

    public static <T> void filter(Collection<T> collection, Predicate<? super T> predicate) {
        collection.removeIf(predicate.negate());
    }

    public static <T, R> List<R> transform(Collection<? extends T> c, Function<T, R> transformer) {
        ArrayList<R> result = new ArrayList<R>(c.size());
        for (T obj : c) {
            result.add(transformer.apply(obj));
        }
        return result;
    }

    public static <K, V> MultiValueMap<K, V> buckets(V[] c, Function<V, K> transformer) {
        DefaultMultiValueMap<K, V> buckets = MultiValueMap.fromLinkedHashMap();
        for (V value : c) {
            K key = transformer.apply(value);
            buckets.add(key, value);
        }
        return buckets;
    }

    public static <K, V> MultiValueMap<K, V> buckets(Iterable<V> c, Function<V, K> transformer) {
        DefaultMultiValueMap<K, V> buckets = MultiValueMap.fromLinkedHashMap();
        for (V value : c) {
            K key = transformer.apply(value);
            buckets.add(key, value);
        }
        return buckets;
    }

    @Nullable
    public static <T> T firstElement(@Nullable Iterable<T> iterable) {
        if (iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return null;
        }
        if (iterable instanceof SortedSet) {
            return (T)((SortedSet)iterable).first();
        }
        Iterator<T> it = iterable.iterator();
        T first = null;
        if (it.hasNext()) {
            first = it.next();
        }
        return first;
    }

    @Nullable
    public static <T> T firstElement(@Nullable List<T> list) {
        return CollectionUtils.getElement(list, 0);
    }

    @Nullable
    public static <T> T firstElement(@Nullable T[] array) {
        return CollectionUtils.getElement(array, 0);
    }

    @Nullable
    public static <T> T lastElement(@Nullable List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> T lastElement(@Nullable T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[array.length - 1];
    }

    @Nullable
    public static <T> T lastElement(@Nullable Set<T> set) {
        if (CollectionUtils.isEmpty(set)) {
            return null;
        }
        if (set instanceof SortedSet) {
            return (T)((SortedSet)set).last();
        }
        Iterator<T> it = set.iterator();
        T last = null;
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    public static <A, E extends A> A[] toArray(@Nullable Enumeration<E> enumeration, A[] array) {
        if (enumeration != null) {
            ArrayList<E> elements = new ArrayList<E>();
            while (enumeration.hasMoreElements()) {
                elements.add(enumeration.nextElement());
            }
            return elements.toArray(array);
        }
        return array;
    }

    public static <A, E extends A> A[] toArray(@Nullable Iterator<E> iterator, A[] array) {
        if (iterator != null) {
            ArrayList<E> elements = new ArrayList<E>();
            while (iterator.hasNext()) {
                elements.add(iterator.next());
            }
            return elements.toArray(array);
        }
        return array;
    }

    public static <E> Iterator<E> toIterator(@Nullable Enumeration<E> enumeration) {
        return enumeration != null ? enumeration.asIterator() : Collections.emptyIterator();
    }

    public static <E> Iterator<E> singletonIterator(E e) {
        return new SingletonIterator<E>(e);
    }

    public static <K, V> HashMap<K, V> newHashMap(int expectedSize) {
        return new HashMap(CollectionUtils.computeMapInitialCapacity(expectedSize), 0.75f);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int expectedSize) {
        return new LinkedHashMap(CollectionUtils.computeMapInitialCapacity(expectedSize), 0.75f);
    }

    private static int computeMapInitialCapacity(int expectedSize) {
        return (int)Math.ceil((double)expectedSize / 0.75);
    }

    public static List<?> arrayToList(@Nullable Object source) {
        Object[] objectArray = ObjectUtils.toObjectArray(source);
        return CollectionUtils.newArrayList(objectArray);
    }

    public static <E> void mergeArrayIntoCollection(@Nullable Object array, Collection<E> collection) {
        Object[] arr;
        for (Object elem : arr = ObjectUtils.toObjectArray(array)) {
            collection.add(elem);
        }
    }

    public static <K, V> void mergePropertiesIntoMap(@Nullable Properties props, Map<K, V> map) {
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = props.get(key);
                if (value == null) {
                    value = props.getProperty(key);
                }
                map.put(key, value);
            }
        }
    }

    public static boolean contains(@Nullable Iterator<?> iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(@Nullable Enumeration<?> enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(@Nullable Iterable<?> iterable, Object element) {
        if (iterable != null) {
            if (iterable instanceof Collection) {
                return ((Collection)iterable).contains(element);
            }
            for (Object candidate : iterable) {
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(@Nullable Collection<?> collection, Object element) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection<?> source, Collection<?> candidates) {
        return CollectionUtils.findFirstMatch(source, candidates) != null;
    }

    @Nullable
    public static <E> E findFirstMatch(Collection<?> source, Collection<E> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        for (E candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (Object elem : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T> T findValueOfType(Collection<?> collection, @Nullable Class<T> type) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        T value = null;
        for (Object element : collection) {
            if (type != null && !type.isInstance(element)) continue;
            if (value != null) {
                return null;
            }
            value = (T)element;
        }
        return value;
    }

    @Nullable
    public static Object findValueOfType(Collection<?> collection, Class<?>[] types) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(types)) {
            return null;
        }
        for (Class<?> type : types) {
            Object value = CollectionUtils.findValueOfType(collection, type);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    static {
        approximableCollectionTypes.add(Collection.class);
        approximableCollectionTypes.add(List.class);
        approximableCollectionTypes.add(Set.class);
        approximableCollectionTypes.add(SortedSet.class);
        approximableCollectionTypes.add(NavigableSet.class);
        approximableMapTypes.add(Map.class);
        approximableMapTypes.add(SortedMap.class);
        approximableMapTypes.add(NavigableMap.class);
        approximableCollectionTypes.add(ArrayList.class);
        approximableCollectionTypes.add(LinkedList.class);
        approximableCollectionTypes.add(HashSet.class);
        approximableCollectionTypes.add(LinkedHashSet.class);
        approximableCollectionTypes.add(TreeSet.class);
        approximableCollectionTypes.add(EnumSet.class);
        approximableMapTypes.add(HashMap.class);
        approximableMapTypes.add(LinkedHashMap.class);
        approximableMapTypes.add(TreeMap.class);
        approximableMapTypes.add(EnumMap.class);
    }
}

