/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.bytecode.ClassReader;
import cn.taketoday.core.GenericTypeResolver;
import cn.taketoday.core.io.Resource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import java.beans.Introspector;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;

public abstract class ClassUtils {
    public static final String CGLIB_CLASS_SEPARATOR = "$$";
    public static final char INNER_CLASS_SEPARATOR = '$';
    public static final String ARRAY_SUFFIX = "[]";
    public static final String INTERNAL_ARRAY_PREFIX = "[";
    public static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    public static final String CLASS_FILE_SUFFIX = ".class";
    public static HashSet<Class<?>> primitiveTypes;
    private static final IdentityHashMap<Class<?>, Class<?>> primitiveWrapperTypeMap;
    private static final IdentityHashMap<Class<?>, Class<?>> primitiveTypeToWrapperMap;
    private static final HashMap<String, Class<?>> primitiveTypeNameMap;
    private static final HashMap<String, Class<?>> commonClassCache;
    private static final Set<Class<?>> javaLanguageInterfaces;

    private static void registerCommonClasses(Class<?> ... commonClasses) {
        for (Class<?> clazz : commonClasses) {
            commonClassCache.put(clazz.getName(), clazz);
        }
    }

    @Nullable
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    @Nullable
    public static ClassLoader overrideThreadContextClassLoader(@Nullable ClassLoader classLoaderToUse) {
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        if (classLoaderToUse != null && !classLoaderToUse.equals(threadContextClassLoader)) {
            currentThread.setContextClassLoader(classLoaderToUse);
            return threadContextClassLoader;
        }
        return null;
    }

    public static boolean isPresent(String className) {
        return ClassUtils.isPresent(className, null);
    }

    public static boolean isPresent(String className, @Nullable ClassLoader classLoader) {
        try {
            ClassUtils.forName(className, classLoader);
            return true;
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        if (name != null && name.length() <= 8) {
            return primitiveTypeNameMap.get(name);
        }
        return null;
    }

    public static <T> Class<T> forName(String name, @Nullable ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Assert.notNull((Object)name, "Name must not be null");
        return ClassUtils.doForName(name, classLoader);
    }

    private static Class<?> doForName(String name, @Nullable ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz == null) {
            clazz = commonClassCache.get(name);
        }
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            Class<?> elementClass = ClassUtils.doForName(name.substring(0, name.length() - ARRAY_SUFFIX.length()), classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
            Class<?> elementClass = ClassUtils.doForName(name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1), classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
            Class<?> elementClass = ClassUtils.doForName(name.substring(INTERNAL_ARRAY_PREFIX.length()), classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        try {
            return Class.forName(name, false, classLoader);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = name.substring(0, lastDotIndex) + "$" + name.substring(lastDotIndex + 1);
                try {
                    return Class.forName(innerClassName, false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static <T> Class<T> forName(String name) throws ClassNotFoundException {
        return ClassUtils.forName(name, ClassUtils.getDefaultClassLoader());
    }

    public static <T> Class<T> resolveClassName(String className, @Nullable ClassLoader classLoader) throws IllegalArgumentException {
        try {
            return ClassUtils.forName(className, classLoader);
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (LinkageError err) {
            throw new IllegalArgumentException("Unresolvable class definition for class [" + className + "]", err);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not find class [" + className + "]", ex);
        }
    }

    @Nullable
    public static <T> Class<T> load(String name) {
        return ClassUtils.load(name, ClassUtils.getDefaultClassLoader());
    }

    @Nullable
    public static <T> Class<T> load(String name, ClassLoader classLoader) {
        try {
            return ClassUtils.forName(name, classLoader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            return null;
        }
    }

    public static String getClassName(ClassReader r) {
        return r.getClassName().replace('/', '.');
    }

    public static String getClassName(byte[] classFile) {
        return ClassUtils.getClassName(new ClassReader(classFile));
    }

    public static String getClassName(Resource resource) throws IOException {
        try (InputStream inputStream = resource.getInputStream();){
            String string = ClassUtils.getClassName(inputStream);
            return string;
        }
    }

    public static String getClassName(InputStream inputStream) throws IOException {
        return ClassUtils.getClassName(new ClassReader(inputStream));
    }

    public static boolean isJavaLanguageInterface(Class<?> ifc) {
        return javaLanguageInterfaces.contains(ifc);
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isLambdaClass(Class<?> clazz) {
        return clazz.isSynthetic() && clazz.getSuperclass() == Object.class && clazz.getInterfaces().length > 0 && clazz.getName().contains("$$Lambda");
    }

    public static <T> Class<T> getUserClass(T synthetic) {
        Assert.notNull(synthetic, "synthetic must not be null");
        return ClassUtils.getUserClass(synthetic.getClass());
    }

    public static <T> Class<T> getUserClass(Class<T> syntheticClass) {
        Class<T> superclass;
        Assert.notNull(syntheticClass, "syntheticClass must not be null");
        if (syntheticClass.getName().lastIndexOf(CGLIB_CLASS_SEPARATOR) > -1 && (superclass = syntheticClass.getSuperclass()) != null && superclass != Object.class) {
            return superclass;
        }
        return syntheticClass;
    }

    public static <T> Class<T> getUserClass(String name) {
        Assert.notNull((Object)name, "synthetic-name must not be null");
        int i = name.indexOf(CGLIB_CLASS_SEPARATOR);
        return i > 0 ? ClassUtils.load(name.substring(0, i)) : ClassUtils.load(name);
    }

    @Nullable
    public static String getDescriptiveType(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        if (Proxy.isProxyClass(clazz)) {
            String prefix = clazz.getName() + " implementing ";
            StringJoiner result = new StringJoiner(",", prefix, "");
            for (Class<?> ifc : clazz.getInterfaces()) {
                result.add(ifc.getName());
            }
            return result.toString();
        }
        return clazz.getTypeName();
    }

    public static Type[] getGenerics(Class<?> type) {
        if (type != null) {
            Class<?> superclass;
            Type genericSuperclass = type.getGenericSuperclass();
            if (genericSuperclass == (superclass = type.getSuperclass()) && genericSuperclass != Object.class) {
                return ClassUtils.getGenerics(superclass);
            }
            if (genericSuperclass instanceof ParameterizedType) {
                return ClassUtils.getActualTypeArguments(genericSuperclass);
            }
            Object[] genericInterfaces = type.getGenericInterfaces();
            if (ObjectUtils.isNotEmpty(genericInterfaces)) {
                return ClassUtils.getActualTypeArguments((Type)genericInterfaces[0]);
            }
        }
        return null;
    }

    @Nullable
    public static Type[] getGenericTypes(Field property) {
        return property != null ? ClassUtils.getActualTypeArguments(property.getGenericType()) : null;
    }

    @Nullable
    public static Type[] getGenericTypes(Parameter parameter) {
        return parameter != null ? ClassUtils.getActualTypeArguments(parameter.getParameterizedType()) : null;
    }

    @Nullable
    static Type[] getActualTypeArguments(Type pType) {
        if (pType instanceof ParameterizedType) {
            return ((ParameterizedType)pType).getActualTypeArguments();
        }
        return null;
    }

    @Nullable
    public static Class<?>[] getGenerics(Class<?> type, Class<?> superClass) {
        return GenericTypeResolver.resolveTypeArguments(type, superClass);
    }

    public static String getQualifiedMethodName(Method method) {
        return ClassUtils.getQualifiedMethodName(method, null);
    }

    public static String getQualifiedMethodName(Method method, @Nullable Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        return (clazz != null ? clazz : method.getDeclaringClass()).getName() + "." + method.getName();
    }

    public static boolean isSimpleType(Class<?> clazz) {
        return primitiveTypes.contains(clazz) || clazz.isArray() && ClassUtils.isSimpleType(clazz.getComponentType());
    }

    public static Class<?>[] getAllInterfaces(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClass(instance.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, ClassLoader classLoader) {
        return ClassUtils.toClassArray(ClassUtils.getAllInterfacesForClassAsSet(clazz, classLoader));
    }

    public static Class<?>[] toClassArray(Collection<Class<?>> collection) {
        return CollectionUtils.isEmpty(collection) ? Constant.EMPTY_CLASSES : collection.toArray(Constant.EMPTY_CLASSES);
    }

    public static Set<Class<?>> getAllInterfacesAsSet(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClassAsSet(instance.getClass());
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClassAsSet(clazz, null);
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz, ClassLoader classLoader) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface() && ClassUtils.isVisible(clazz, classLoader)) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = current.getInterfaces()) {
                if (!ClassUtils.isVisible(ifc, classLoader)) continue;
                interfaces.add(ifc);
            }
        }
        return interfaces;
    }

    public static Class<?> createCompositeInterface(Class<?>[] interfaces, @Nullable ClassLoader classLoader) {
        Assert.notEmpty((Object[])interfaces, "Interface array must not be empty");
        return Proxy.getProxyClass(classLoader, interfaces);
    }

    @Nullable
    public static Class<?> determineCommonAncestor(@Nullable Class<?> clazz1, @Nullable Class<?> clazz2) {
        if (clazz1 == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz1;
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return clazz1;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return clazz2;
        }
        Class<?> ancestor = clazz1;
        do {
            if ((ancestor = ancestor.getSuperclass()) != null && Object.class != ancestor) continue;
            return null;
        } while (!ancestor.isAssignableFrom(clazz2));
        return ancestor;
    }

    public static boolean isCacheSafe(Class<?> clazz, @Nullable ClassLoader classLoader) {
        Assert.notNull(clazz, "Class must not be null");
        try {
            ClassLoader target = clazz.getClassLoader();
            if (target == classLoader || target == null) {
                return true;
            }
            if (classLoader == null) {
                return false;
            }
            ClassLoader current = classLoader;
            while (current != null) {
                if ((current = current.getParent()) != target) continue;
                return true;
            }
            while (target != null) {
                if ((target = target.getParent()) != classLoader) continue;
                return false;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return classLoader != null && ClassUtils.isLoadable(clazz, classLoader);
    }

    public static boolean isVisible(Class<?> clazz, @Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            if (clazz.getClassLoader() == classLoader) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ClassUtils.isLoadable(clazz, classLoader);
    }

    private static boolean isLoadable(Class<?> clazz, ClassLoader classLoader) {
        try {
            return clazz == classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static String classNamesToString(Class<?> ... classes) {
        return ClassUtils.classNamesToString(Arrays.asList(classes));
    }

    public static String classNamesToString(Collection<Class<?>> classes) {
        if (CollectionUtils.isEmpty(classes)) {
            return ARRAY_SUFFIX;
        }
        StringJoiner stringJoiner = new StringJoiner(", ", INTERNAL_ARRAY_PREFIX, "]");
        for (Class<?> clazz : classes) {
            stringJoiner.add(clazz.getName());
        }
        return stringJoiner.toString();
    }

    public static String getPackageName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fqClassName) {
        Assert.notNull((Object)fqClassName, "Class name must not be null");
        int lastDotIndex = fqClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }

    public static Object[] adaptArgumentsIfNecessary(Method method, @Nullable Object[] arguments) {
        Object varargArray;
        int varargIndex;
        Class<?>[] paramTypes;
        Class<?> varargType;
        if (ObjectUtils.isEmpty(arguments)) {
            return Constant.EMPTY_OBJECTS;
        }
        if (method.isVarArgs() && method.getParameterCount() == arguments.length && (varargType = (paramTypes = method.getParameterTypes())[varargIndex = paramTypes.length - 1]).isArray() && (varargArray = arguments[varargIndex]) instanceof Object[] && !varargType.isInstance(varargArray)) {
            Object[] newArguments = new Object[arguments.length];
            System.arraycopy(arguments, 0, newArguments, 0, varargIndex);
            Class<?> targetElementType = varargType.getComponentType();
            int varargLength = Array.getLength(varargArray);
            Object newVarargArray = Array.newInstance(targetElementType, varargLength);
            System.arraycopy(varargArray, 0, newVarargArray, 0, varargLength);
            newArguments[varargIndex] = newVarargArray;
            return newArguments;
        }
        return arguments;
    }

    public static String getQualifiedName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.getTypeName();
    }

    public static String getShortName(String className) {
        Assert.hasLength(className, "Class name must not be empty");
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf(CGLIB_CLASS_SEPARATOR);
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    public static String getSimpleName(String className) {
        String simpleName = ClassUtils.getShortName(className);
        int innerIndex = simpleName.indexOf(46);
        if (innerIndex > -1) {
            simpleName = simpleName.substring(innerIndex + 1);
        }
        return simpleName;
    }

    public static boolean matchesTypeName(Class<?> clazz, @Nullable String typeName) {
        return typeName != null && (typeName.equals(clazz.getTypeName()) || typeName.equals(clazz.getSimpleName()));
    }

    public static String getShortName(Class<?> clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getShortNameAsProperty(Class<?> clazz) {
        String shortName = ClassUtils.getShortName(clazz);
        int dotIndex = shortName.lastIndexOf(46);
        shortName = dotIndex != -1 ? shortName.substring(dotIndex + 1) : shortName;
        return Introspector.decapitalize(shortName);
    }

    public static String getClassFileName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return className.substring(lastDotIndex + 1) + CLASS_FILE_SUFFIX;
    }

    public static String getFullyClassFileName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        String className = clazz.getName();
        return className.replace('.', '/') + CLASS_FILE_SUFFIX;
    }

    public static String classPackageAsResourcePath(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, packageEndIndex);
        return packageName.replace('.', '/');
    }

    public static String convertResourcePathToClassName(String resourcePath) {
        Assert.notNull((Object)resourcePath, "Resource path must not be null");
        return resourcePath.replace('/', '.');
    }

    public static String convertClassNameToResourcePath(String className) {
        Assert.notNull((Object)className, "Class name must not be null");
        return className.replace('.', '/');
    }

    public static String addResourcePathToPackagePath(Class<?> clazz, String resourceName) {
        Assert.notNull((Object)resourceName, "Resource name must not be null");
        if (!resourceName.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + "/" + resourceName;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + resourceName;
    }

    public static Class<?> getEnumType(Class<?> targetType) {
        Class<?> enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        if (enumType == null) {
            throw new IllegalArgumentException("The target " + targetType + " does not refer to an enum");
        }
        return enumType;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return primitiveWrapperTypeMap.containsKey(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveArray(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isArray() && ClassUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() && clazz != Void.TYPE ? primitiveTypeToWrapperMap.get(clazz) : clazz;
    }

    public static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        Assert.notNull(lhsType, "Left-hand side type must not be null");
        Assert.notNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.isAssignableFrom(rhsType)) {
            return true;
        }
        if (lhsType.isPrimitive()) {
            Class<?> resolvedPrimitive = primitiveWrapperTypeMap.get(rhsType);
            return lhsType == resolvedPrimitive;
        }
        Class<?> resolvedWrapper = primitiveTypeToWrapperMap.get(rhsType);
        return resolvedWrapper != null && lhsType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isAssignableValue(Class<?> type, @Nullable Object value) {
        Assert.notNull(type, "Type must not be null");
        return value != null ? ClassUtils.isAssignable(type, value.getClass()) : !type.isPrimitive();
    }

    public static boolean isUserLevelMethod(Method method) {
        Assert.notNull((Object)method, "Method must not be null");
        return method.isBridge() || !method.isSynthetic() && !ClassUtils.isGroovyObjectMethod(method);
    }

    private static boolean isGroovyObjectMethod(Method method) {
        return method.getDeclaringClass().getName().equals("groovy.lang.GroovyObject");
    }

    static {
        primitiveWrapperTypeMap = new IdentityHashMap(9);
        primitiveTypeToWrapperMap = new IdentityHashMap(9);
        primitiveTypeNameMap = new HashMap(32);
        commonClassCache = new HashMap(64);
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        primitiveWrapperTypeMap.put(Void.class, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : primitiveWrapperTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(entry.getValue(), entry.getKey());
            ClassUtils.registerCommonClasses(entry.getKey());
        }
        HashSet primitiveTypes = new HashSet(32);
        primitiveTypes.addAll(primitiveWrapperTypeMap.values());
        Collections.addAll(primitiveTypes, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class);
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
        ClassUtils.registerCommonClasses(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        ClassUtils.registerCommonClasses(Number.class, Number[].class, String.class, String[].class, Class.class, Class[].class, Object.class, Object[].class);
        ClassUtils.registerCommonClasses(Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
        ClassUtils.registerCommonClasses(Enum.class, Iterable.class, Iterator.class, Enumeration.class, Collection.class, List.class, Set.class, Map.class, Map.Entry.class, Optional.class);
        Class[] classArray = new Class[]{Serializable.class, Externalizable.class, Closeable.class, AutoCloseable.class, Cloneable.class, Comparable.class};
        ClassUtils.registerCommonClasses(classArray);
        javaLanguageInterfaces = Set.of(classArray);
        primitiveTypes.add(Void.TYPE);
        primitiveTypes.add(String.class);
        primitiveTypes.add(Byte.class);
        primitiveTypes.add(Short.class);
        primitiveTypes.add(Character.class);
        primitiveTypes.add(Integer.class);
        primitiveTypes.add(Long.class);
        primitiveTypes.add(Float.class);
        primitiveTypes.add(Double.class);
        primitiveTypes.add(Boolean.class);
        primitiveTypes.add(Date.class);
        primitiveTypes.add(Class.class);
        primitiveTypes.add(BigInteger.class);
        primitiveTypes.add(BigDecimal.class);
        primitiveTypes.add(URI.class);
        primitiveTypes.add(URL.class);
        primitiveTypes.add(Enum.class);
        primitiveTypes.add(Locale.class);
        primitiveTypes.add(Number.class);
        primitiveTypes.add(Temporal.class);
        primitiveTypes.add(CharSequence.class);
        ClassUtils.primitiveTypes = new HashSet(primitiveTypes);
    }
}

