/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<E>
implements Iterator<E>,
Enumeration<E>,
Serializable {
    private int ndx;
    private final E[] array;
    private final int endNdx;

    public ArrayIterator(E[] array) {
        this.ndx = 0;
        this.array = array;
        this.endNdx = array.length;
    }

    public ArrayIterator(E[] array, int offset, int len) {
        this.ndx = offset;
        this.array = array;
        this.endNdx = offset + len;
    }

    @Override
    public boolean hasNext() {
        return this.ndx < this.endNdx;
    }

    @Override
    public E next() throws NoSuchElementException {
        if (this.ndx < this.endNdx) {
            ++this.ndx;
            return this.array[this.ndx - 1];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMoreElements() {
        return this.ndx < this.endNdx;
    }

    @Override
    public E nextElement() {
        return this.next();
    }

    @Override
    public Iterator<E> asIterator() {
        return this;
    }
}

