/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.reflect;

import cn.taketoday.lang.Nullable;
import cn.taketoday.reflect.MethodAccessorSetterMethod;
import cn.taketoday.reflect.MethodInvoker;
import cn.taketoday.reflect.ReflectiveSetterMethod;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public interface SetterMethod {
    public void set(Object var1, Object var2);

    @Nullable
    default public Method getWriteMethod() {
        return null;
    }

    public static SetterMethod fromField(Field field) {
        Method writeMethod = ReflectionUtils.getWriteMethod(field);
        if (writeMethod == null) {
            return SetterMethod.fromReflective(field);
        }
        return SetterMethod.fromMethod(writeMethod);
    }

    public static SetterMethod fromMethod(Method method) {
        MethodInvoker accessor = MethodInvoker.fromMethod(method);
        return SetterMethod.fromMethod(accessor);
    }

    public static SetterMethod fromMethod(MethodInvoker invoker) {
        return new MethodAccessorSetterMethod(invoker);
    }

    public static SetterMethod fromReflective(Field field) {
        ReflectionUtils.makeAccessible(field);
        return new ReflectiveSetterMethod(field);
    }
}

