/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.reflect;

import cn.taketoday.reflect.MethodAccessor;
import cn.taketoday.reflect.MethodInvoker;
import cn.taketoday.util.ExceptionUtils;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Method;

final class ReflectiveMethodAccessor
extends MethodInvoker
implements MethodAccessor {
    private final boolean handleReflectionException;

    ReflectiveMethodAccessor(Method method, boolean handleReflectionException) {
        super(method);
        this.handleReflectionException = handleReflectionException;
    }

    @Override
    public Object invoke(Object obj, Object[] args) {
        try {
            return this.getMethod().invoke(obj, args);
        }
        catch (Exception e) {
            if (this.handleReflectionException) {
                ReflectionUtils.handleReflectionException(e);
            }
            throw ExceptionUtils.sneakyThrow(e);
        }
    }
}

