/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.logging;

import cn.taketoday.logging.Level;
import cn.taketoday.util.CollectionUtils;
import java.io.Serializable;

public abstract class Logger
implements Serializable {
    protected static final String FQCN = Logger.class.getName();
    protected final boolean debugEnabled;

    protected Logger(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public abstract String getName();

    public abstract boolean isTraceEnabled();

    public void trace(String msg) {
        this.logInternal(Level.TRACE, msg, null, null);
    }

    public void trace(String format, Object arg) {
        this.logInternal(Level.TRACE, format, null, new Object[]{arg});
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logInternal(Level.TRACE, format, null, new Object[]{arg1, arg2});
    }

    public void trace(String format, Object ... arguments) {
        this.logInternal(arguments, Level.TRACE, format);
    }

    public void trace(String msg, Throwable t) {
        this.logInternal(Level.TRACE, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void debug(String msg) {
        this.logInternal(Level.DEBUG, msg, null, null);
    }

    public void debug(String format, Object arg) {
        this.logInternal(Level.DEBUG, format, null, new Object[]{arg});
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logInternal(Level.DEBUG, format, null, new Object[]{arg1, arg2});
    }

    public void debug(String format, Object ... arguments) {
        this.logInternal(arguments, Level.DEBUG, format);
    }

    public void debug(String msg, Throwable t) {
        this.logInternal(Level.DEBUG, msg, t);
    }

    public abstract boolean isInfoEnabled();

    public void info(String msg) {
        this.logInternal(Level.INFO, msg, null, null);
    }

    public void info(String format, Object arg) {
        this.logInternal(Level.INFO, format, null, new Object[]{arg});
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logInternal(Level.INFO, format, null, new Object[]{arg1, arg2});
    }

    public void info(String format, Object ... arguments) {
        this.logInternal(arguments, Level.INFO, format);
    }

    public void info(String msg, Throwable t) {
        this.logInternal(Level.INFO, msg, t, null);
    }

    public abstract boolean isWarnEnabled();

    public void warn(String msg) {
        this.logInternal(Level.WARN, msg, null, null);
    }

    public void warn(String format, Object arg) {
        this.logInternal(Level.WARN, format, null, new Object[]{arg});
    }

    public void warn(String format, Object ... arguments) {
        this.logInternal(arguments, Level.WARN, format);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logInternal(Level.WARN, format, null, new Object[]{arg1, arg2});
    }

    public void warn(String msg, Throwable t) {
        this.logInternal(Level.WARN, msg, t, null);
    }

    public abstract boolean isErrorEnabled();

    public void error(String msg) {
        this.logInternal(Level.ERROR, msg, null, null);
    }

    public void error(String format, Object arg) {
        this.logInternal(Level.ERROR, format, null, new Object[]{arg});
    }

    public void error(String format, Object arg, Throwable throwable) {
        this.logInternal(Level.ERROR, format, throwable, new Object[]{arg});
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logInternal(Level.ERROR, format, null, new Object[]{arg1, arg2});
    }

    public void error(String format, Object arg1, Object arg2, Throwable throwable) {
        this.logInternal(Level.ERROR, format, throwable, new Object[]{arg1, arg2});
    }

    public void error(String format, Object ... arguments) {
        this.logInternal(arguments, Level.ERROR, format);
    }

    public void error(String msg, Throwable t) {
        this.logInternal(Level.ERROR, msg, t, null);
    }

    public void error(Object message) {
        this.logInternal(Level.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.logInternal(Level.ERROR, message, t);
    }

    public void warn(Object message) {
        this.logInternal(Level.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.logInternal(Level.WARN, message, t);
    }

    public void info(Object message) {
        this.logInternal(Level.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.logInternal(Level.INFO, message, t);
    }

    public void debug(Object message) {
        this.logInternal(Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.logInternal(Level.DEBUG, message, t);
    }

    public void trace(Object message) {
        this.logInternal(Level.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.logInternal(Level.TRACE, message, t);
    }

    private void logInternal(Object[] arguments, Level trace, String format) {
        Object lastElement = CollectionUtils.lastElement(arguments);
        if (lastElement instanceof Throwable) {
            Throwable throwable = (Throwable)lastElement;
            this.logInternal(trace, format, throwable, arguments);
        } else {
            this.logInternal(trace, format, null, arguments);
        }
    }

    protected abstract void logInternal(Level var1, String var2, Throwable var3, Object[] var4);

    protected abstract void logInternal(Level var1, Object var2, Throwable var3);
}

