/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.logging;

import cn.taketoday.logging.CompositeLogger;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;

public final class LogDelegateFactory {
    private LogDelegateFactory() {
    }

    public static Logger getCompositeLog(Logger primaryLogger, Logger secondaryLogger, Logger ... tertiaryLoggers) {
        ArrayList<Logger> loggers = new ArrayList<Logger>(2 + tertiaryLoggers.length);
        loggers.add(primaryLogger);
        loggers.add(secondaryLogger);
        Collections.addAll(loggers, tertiaryLoggers);
        return new CompositeLogger(loggers, primaryLogger.getName());
    }

    public static Logger getHiddenLog(Class<?> clazz) {
        return LogDelegateFactory.getHiddenLog(clazz.getName());
    }

    public static Logger getHiddenLog(String category) {
        return LoggerFactory.getLogger("_" + category);
    }
}

