/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.logging;

import cn.taketoday.logging.Level;
import cn.taketoday.logging.Slf4jLogger;
import org.slf4j.Logger;
import org.slf4j.spi.LocationAwareLogger;

final class LocationAwareSlf4jLogger
extends Slf4jLogger {
    private final LocationAwareLogger log;

    public LocationAwareSlf4jLogger(LocationAwareLogger log) {
        super((Logger)log);
        this.log = log;
    }

    @Override
    protected void logInternal(Level level, Object msg, Throwable t) {
        String message = String.valueOf(msg);
        this.log.log(null, FQCN, LocationAwareSlf4jLogger.getLevel(level), message, null, t);
    }

    private static int getLevel(Level level) {
        return switch (level) {
            case Level.DEBUG -> 10;
            case Level.ERROR -> 40;
            case Level.TRACE -> 0;
            case Level.WARN -> 30;
            default -> 20;
        };
    }

    @Override
    protected void logInternal(Level level, String format, Throwable t, Object[] args) {
        this.log.log(null, FQCN, LocationAwareSlf4jLogger.getLevel(level), format, args, t);
    }
}

