/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.logging;

import cn.taketoday.logging.Level;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.NoOpLogger;
import java.util.List;
import java.util.function.Predicate;

final class CompositeLogger
extends Logger {
    private static final Logger NO_OP_LOG = new NoOpLogger();
    private final Logger errorLogger;
    private final Logger warnLogger;
    private final Logger infoLogger;
    private final Logger debugLogger;
    private final Logger traceLogger;
    private final String name;

    public CompositeLogger(List<Logger> loggers, String name) {
        super(CompositeLogger.initLogger(loggers, Logger::isDebugEnabled) != NO_OP_LOG);
        this.errorLogger = CompositeLogger.initLogger(loggers, Logger::isErrorEnabled);
        this.warnLogger = CompositeLogger.initLogger(loggers, Logger::isWarnEnabled);
        this.infoLogger = CompositeLogger.initLogger(loggers, Logger::isInfoEnabled);
        this.debugLogger = CompositeLogger.initLogger(loggers, Logger::isDebugEnabled);
        this.traceLogger = CompositeLogger.initLogger(loggers, Logger::isTraceEnabled);
        this.name = name;
    }

    private static Logger initLogger(List<Logger> loggers, Predicate<Logger> predicate) {
        for (Logger logger : loggers) {
            if (!predicate.test(logger)) continue;
            return logger;
        }
        return NO_OP_LOG;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.errorLogger != NO_OP_LOG;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.warnLogger != NO_OP_LOG;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoLogger != NO_OP_LOG;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.traceLogger != NO_OP_LOG;
    }

    @Override
    protected void logInternal(Level level, Object msg, Throwable t) {
        this.logger(level).logInternal(level, msg, t);
    }

    private Logger logger(Level level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case Level.INFO -> this.infoLogger;
            case Level.WARN -> this.warnLogger;
            case Level.ERROR -> this.errorLogger;
            case Level.DEBUG -> this.debugLogger;
            case Level.TRACE -> this.traceLogger;
        };
    }

    @Override
    protected void logInternal(Level level, String msg, Throwable t, Object[] args) {
        this.logger(level).logInternal(level, msg, t, args);
    }
}

