/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.spel.support;

import cn.taketoday.core.MethodParameter;
import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.expression.AccessException;
import cn.taketoday.expression.EvaluationContext;
import cn.taketoday.expression.MethodExecutor;
import cn.taketoday.expression.TypedValue;
import cn.taketoday.expression.spel.support.ReflectionHelper;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectiveMethodExecutor
implements MethodExecutor {
    private final Method originalMethod;
    private final Method methodToInvoke;
    @Nullable
    private final Integer varargsPosition;
    private boolean computedPublicDeclaringClass = false;
    @Nullable
    private Class<?> publicDeclaringClass;
    private boolean argumentConversionOccurred = false;

    public ReflectiveMethodExecutor(Method method) {
        this(method, null);
    }

    public ReflectiveMethodExecutor(Method method, @Nullable Class<?> targetClass) {
        this.originalMethod = method;
        this.methodToInvoke = ReflectionUtils.getInterfaceMethodIfPossible(method, targetClass);
        this.varargsPosition = method.isVarArgs() ? Integer.valueOf(method.getParameterCount() - 1) : null;
    }

    public final Method getMethod() {
        return this.originalMethod;
    }

    @Nullable
    public Class<?> getPublicDeclaringClass() {
        if (!this.computedPublicDeclaringClass) {
            this.publicDeclaringClass = this.discoverPublicDeclaringClass(this.originalMethod, this.originalMethod.getDeclaringClass());
            this.computedPublicDeclaringClass = true;
        }
        return this.publicDeclaringClass;
    }

    @Nullable
    private Class<?> discoverPublicDeclaringClass(Method method, Class<?> clazz) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return clazz;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (clazz.getSuperclass() != null) {
            return this.discoverPublicDeclaringClass(method, clazz.getSuperclass());
        }
        return null;
    }

    public boolean didArgumentConversionOccur() {
        return this.argumentConversionOccurred;
    }

    @Override
    public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
        try {
            this.argumentConversionOccurred = ReflectionHelper.convertArguments(context.getTypeConverter(), arguments, this.originalMethod, this.varargsPosition);
            if (this.originalMethod.isVarArgs()) {
                arguments = ReflectionHelper.setupArgumentsForVarargsInvocation(this.originalMethod.getParameterTypes(), arguments);
            }
            ReflectionUtils.makeAccessible(this.methodToInvoke);
            Object value = this.methodToInvoke.invoke(target, arguments);
            return new TypedValue(value, new TypeDescriptor(new MethodParameter(this.originalMethod, -1)).narrow(value));
        }
        catch (Exception ex) {
            throw new AccessException("Problem invoking method: " + this.methodToInvoke, ex);
        }
    }
}

