/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.spel.standard;

import cn.taketoday.bytecode.BytecodeCompiler;
import cn.taketoday.bytecode.ClassWriter;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.Opcodes;
import cn.taketoday.bytecode.core.CodeFlow;
import cn.taketoday.expression.Expression;
import cn.taketoday.expression.spel.CompiledExpression;
import cn.taketoday.expression.spel.ast.SpelNodeImpl;
import cn.taketoday.expression.spel.standard.SpelExpression;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.StringUtils;
import java.util.concurrent.atomic.AtomicInteger;

public final class SpelCompiler
extends BytecodeCompiler
implements Opcodes {
    private static final Logger logger = LoggerFactory.getLogger(SpelCompiler.class);
    private static final ConcurrentReferenceHashMap<ClassLoader, SpelCompiler> compilers = new ConcurrentReferenceHashMap();
    private final AtomicInteger suffixId = new AtomicInteger(1);

    private SpelCompiler(@Nullable ClassLoader classloader) {
        super(classloader);
    }

    @Nullable
    public CompiledExpression compile(SpelNodeImpl expression) {
        if (expression.isCompilable()) {
            Class<? extends CompiledExpression> clazz;
            if (logger.isDebugEnabled()) {
                logger.debug("SpEL: compiling {}", (Object)expression.toStringAST());
            }
            if ((clazz = this.createExpressionClass(expression)) != null) {
                try {
                    return ReflectionUtils.accessibleConstructor(clazz, new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to instantiate CompiledExpression for expression: " + expression.toStringAST(), ex);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SpEL: unable to compile {}", (Object)expression.toStringAST());
        }
        return null;
    }

    private int getNextSuffix() {
        return this.suffixId.incrementAndGet();
    }

    @Nullable
    private Class<? extends CompiledExpression> createExpressionClass(SpelNodeImpl expressionToCompile) {
        Object className = "spel/Ex" + this.getNextSuffix();
        ExpressionClassWriter cw = new ExpressionClassWriter();
        cw.visit(52, 1, (String)className, null, "cn/taketoday/expression/spel/CompiledExpression", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "cn/taketoday/expression/spel/CompiledExpression", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getValue", "(Ljava/lang/Object;Lcn/taketoday/expression/EvaluationContext;)Ljava/lang/Object;", null, new String[]{"cn/taketoday/expression/EvaluationException"});
        mv.visitCode();
        CodeFlow cf = new CodeFlow((String)className, cw);
        try {
            expressionToCompile.generateCode(mv, cf);
        }
        catch (IllegalStateException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}.generateCode opted out of compilation: {}", (Object)expressionToCompile.getClass().getSimpleName(), (Object)ex.getMessage());
            }
            return null;
        }
        CodeFlow.insertBoxIfNecessary(mv, cf.lastDescriptor());
        if ("V".equals(cf.lastDescriptor())) {
            mv.visitInsn(1);
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        cf.finish();
        byte[] data = cw.toByteArray();
        className = StringUtils.replace((String)className, "/", ".");
        return this.compile((String)className, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpelCompiler getCompiler(@Nullable ClassLoader classLoader) {
        SpelCompiler compiler;
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        if ((compiler = compilers.get(classLoader)) == null) {
            ConcurrentReferenceHashMap<ClassLoader, SpelCompiler> concurrentReferenceHashMap = compilers;
            synchronized (concurrentReferenceHashMap) {
                compiler = compilers.get(classLoader);
                if (compiler == null) {
                    compiler = new SpelCompiler(classLoader);
                    compilers.put(classLoader, compiler);
                }
            }
        }
        return compiler;
    }

    public static boolean compile(Expression expression) {
        return expression instanceof SpelExpression && ((SpelExpression)expression).compileExpression();
    }

    public static void revertToInterpreted(Expression expression) {
        if (expression instanceof SpelExpression) {
            ((SpelExpression)expression).revertToInterpreted();
        }
    }

    private class ExpressionClassWriter
    extends ClassWriter {
        public ExpressionClassWriter() {
            super(3);
        }

        @Override
        protected ClassLoader getClassLoader() {
            return SpelCompiler.this.childClassLoader;
        }
    }
}

