/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.type.classreading;

import cn.taketoday.bytecode.AnnotationVisitor;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.type.classreading.MergedAnnotationReadingVisitor;
import cn.taketoday.core.type.classreading.SimpleMethodMetadata;
import cn.taketoday.lang.Nullable;
import java.util.ArrayList;
import java.util.function.Consumer;

final class SimpleMethodMetadataReadingVisitor
extends MethodVisitor {
    @Nullable
    private final ClassLoader classLoader;
    private final String declaringClassName;
    private final int access;
    @Nullable
    private ArrayList<MergedAnnotation<?>> annotations;
    private final Consumer<SimpleMethodMetadata> consumer;
    @Nullable
    private Source source;
    private final MethodSignature methodSignature;

    SimpleMethodMetadataReadingVisitor(@Nullable ClassLoader classLoader, String declaringClassName, int access, String methodName, String descriptor, Consumer<SimpleMethodMetadata> consumer) {
        this.access = access;
        this.consumer = consumer;
        this.classLoader = classLoader;
        this.declaringClassName = declaringClassName;
        this.methodSignature = new MethodSignature(methodName, descriptor);
    }

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (this.annotations == null) {
            this.annotations = new ArrayList(4);
        }
        return MergedAnnotationReadingVisitor.get(this.classLoader, this.getSource(), descriptor, visible, this.annotations::add);
    }

    @Override
    public void visitEnd() {
        MergedAnnotations annotations = MergedAnnotations.valueOf(this.annotations);
        SimpleMethodMetadata metadata = new SimpleMethodMetadata(this.access, this.declaringClassName, this.getSource(), annotations, this.methodSignature, this.classLoader);
        this.consumer.accept(metadata);
    }

    private Object getSource() {
        Source source = this.source;
        if (source == null) {
            this.source = source = new Source(this.declaringClassName, this.methodSignature);
        }
        return source;
    }

    static final class Source {
        private final String declaringClassName;
        private final MethodSignature methodSignature;
        @Nullable
        private String toStringValue;

        Source(String declaringClassName, MethodSignature methodSignature) {
            this.declaringClassName = declaringClassName;
            this.methodSignature = methodSignature;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.declaringClassName.hashCode();
            result = 31 * result + this.methodSignature.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Source otherSource = (Source)other;
            return this.declaringClassName.equals(otherSource.declaringClassName) && this.methodSignature.equals(otherSource.methodSignature);
        }

        public String toString() {
            String value = this.toStringValue;
            if (value == null) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.declaringClassName);
                builder.append('.');
                builder.append(this.methodSignature.getName());
                Type[] argumentTypes = this.methodSignature.getArgumentTypes();
                builder.append('(');
                for (int i = 0; i < argumentTypes.length; ++i) {
                    if (i != 0) {
                        builder.append(',');
                    }
                    builder.append(argumentTypes[i].getClassName());
                }
                builder.append(')');
                this.toStringValue = value = builder.toString();
            }
            return value;
        }
    }
}

