/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.type.classreading;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.type.MethodMetadata;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;

final class SimpleMethodMetadata
implements MethodMetadata {
    private final int access;
    private final String declaringClassName;
    private final Object source;
    private final MergedAnnotations annotations;
    private final MethodSignature methodSignature;
    @Nullable
    private volatile String returnTypeName;
    @Nullable
    private final ClassLoader classLoader;

    SimpleMethodMetadata(int access, String declaringClassName, Object source, MergedAnnotations annotations, MethodSignature methodSignature, @Nullable ClassLoader classLoader) {
        this.methodSignature = methodSignature;
        this.access = access;
        this.declaringClassName = declaringClassName;
        this.source = source;
        this.annotations = annotations;
        this.classLoader = classLoader;
    }

    @Override
    public String getMethodName() {
        return this.methodSignature.getName();
    }

    @Override
    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getReturnTypeName() {
        String returnTypeName = this.returnTypeName;
        if (returnTypeName == null) {
            SimpleMethodMetadata simpleMethodMetadata = this;
            synchronized (simpleMethodMetadata) {
                returnTypeName = this.returnTypeName;
                if (returnTypeName == null) {
                    this.returnTypeName = returnTypeName = this.methodSignature.getReturnType().getClassName();
                }
            }
        }
        return returnTypeName;
    }

    @Override
    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && !this.isPrivate();
    }

    @Override
    public int getParameterCount() {
        return this.getArgumentTypes().length;
    }

    private boolean isPrivate() {
        return (this.access & 2) != 0;
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.annotations;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SimpleMethodMetadata && this.source.equals(((SimpleMethodMetadata)obj).source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public String toString() {
        return this.source.toString();
    }

    @Override
    public Type[] getArgumentTypes() {
        return this.methodSignature.getArgumentTypes();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Type[] argumentTypes = this.getArgumentTypes();
        int parameterCount = argumentTypes.length;
        if (parameterCount == 0) {
            return Constant.EMPTY_CLASSES;
        }
        int i = 0;
        Class[] ret = new Class[parameterCount];
        for (Type argumentType : argumentTypes) {
            String className = argumentType.getClassName();
            ret[i++] = ClassUtils.resolveClassName(className, this.classLoader);
        }
        return ret;
    }
}

