/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.type.classreading;

import cn.taketoday.core.io.DefaultResourceLoader;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.core.type.classreading.SimpleMetadataReader;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SimpleMetadataReaderFactory
implements MetadataReaderFactory {
    private final ResourceLoader resourceLoader;

    public SimpleMetadataReaderFactory() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(@Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(@Nullable ClassLoader classLoader) {
        this.resourceLoader = classLoader != null ? new DefaultResourceLoader(classLoader) : new DefaultResourceLoader();
    }

    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public MetadataReader getMetadataReader(String className) throws IOException {
        try {
            String resourcePath = "classpath:" + ClassUtils.convertClassNameToResourcePath(className) + ".class";
            Resource resource = this.resourceLoader.getResource(resourcePath);
            return this.getMetadataReader(resource);
        }
        catch (FileNotFoundException ex) {
            String innerClassName;
            String innerClassResourcePath;
            Resource innerClassResource;
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1 && (innerClassResource = this.resourceLoader.getResource(innerClassResourcePath = "classpath:" + ClassUtils.convertClassNameToResourcePath(innerClassName = className.substring(0, lastDotIndex) + "$" + className.substring(lastDotIndex + 1)) + ".class")).exists()) {
                return this.getMetadataReader(innerClassResource);
            }
            throw ex;
        }
    }

    @Override
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        return new SimpleMetadataReader(resource, this.resourceLoader.getClassLoader());
    }
}

