/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.type;

import cn.taketoday.core.MultiValueMap;
import cn.taketoday.core.annotation.AnnotatedElementUtils;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.annotation.RepeatableContainers;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.MethodMetadata;
import cn.taketoday.core.type.StandardClassMetadata;
import cn.taketoday.core.type.StandardMethodMetadata;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class StandardAnnotationMetadata
extends StandardClassMetadata
implements AnnotationMetadata {
    private final MergedAnnotations mergedAnnotations;
    private final boolean nestedAnnotationsAsMap;
    @Nullable
    private Set<String> annotationTypes;

    public StandardAnnotationMetadata(Class<?> introspectedClass) {
        this(introspectedClass, false);
    }

    public StandardAnnotationMetadata(Class<?> introspectedClass, boolean nestedAnnotationsAsMap) {
        super(introspectedClass);
        this.mergedAnnotations = MergedAnnotations.from(introspectedClass, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS, RepeatableContainers.none());
        this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.mergedAnnotations;
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Set<String> annotationTypes = this.annotationTypes;
        if (annotationTypes == null) {
            this.annotationTypes = annotationTypes = Collections.unmodifiableSet(AnnotationMetadata.super.getAnnotationTypes());
        }
        return annotationTypes;
    }

    @Override
    @Nullable
    public Map<String, Object> getAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        if (this.nestedAnnotationsAsMap) {
            return AnnotationMetadata.super.getAnnotationAttributes(annotationName, classValuesAsString);
        }
        return AnnotatedElementUtils.getMergedAnnotationAttributes(this.getIntrospectedClass(), annotationName, classValuesAsString, false);
    }

    @Override
    @Nullable
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        if (this.nestedAnnotationsAsMap) {
            return AnnotationMetadata.super.getAllAnnotationAttributes(annotationName, classValuesAsString);
        }
        return AnnotatedElementUtils.getAllAnnotationAttributes(this.getIntrospectedClass(), annotationName, classValuesAsString, false);
    }

    @Override
    public boolean hasAnnotatedMethods(String annotationName) {
        if (AnnotationUtils.isCandidateClass(this.getIntrospectedClass(), annotationName)) {
            try {
                Method[] methods;
                for (Method method : methods = ReflectionUtils.getDeclaredMethods(this.getIntrospectedClass())) {
                    if (!StandardAnnotationMetadata.isAnnotatedMethod(method, annotationName)) continue;
                    return true;
                }
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect annotated methods on " + this.getIntrospectedClass(), ex);
            }
        }
        return false;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationName) {
        Set<MethodMetadata> annotatedMethods = null;
        if (AnnotationUtils.isCandidateClass(this.getIntrospectedClass(), annotationName)) {
            try {
                Method[] methods;
                for (Method method : methods = ReflectionUtils.getDeclaredMethods(this.getIntrospectedClass())) {
                    if (!StandardAnnotationMetadata.isAnnotatedMethod(method, annotationName)) continue;
                    if (annotatedMethods == null) {
                        annotatedMethods = new LinkedHashSet<MethodMetadata>(4);
                    }
                    ((HashSet)annotatedMethods).add(this.mapMethod(method));
                }
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect annotated methods on " + this.getIntrospectedClass(), ex);
            }
        }
        return annotatedMethods != null ? annotatedMethods : Collections.emptySet();
    }

    @Override
    protected MethodMetadata mapMethod(Method method) {
        return new StandardMethodMetadata(method, this.nestedAnnotationsAsMap);
    }

    private static boolean isAnnotatedMethod(Method method, String annotationName) {
        return !method.isBridge() && method.getAnnotations().length > 0 && AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, annotationName);
    }

    static AnnotationMetadata from(Class<?> introspectedClass) {
        return new StandardAnnotationMetadata(introspectedClass, true);
    }
}

