/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io.buffer;

import cn.taketoday.core.io.buffer.DataBuffer;
import cn.taketoday.core.io.buffer.DataBufferFactory;
import cn.taketoday.core.io.buffer.Netty5DataBuffer;
import cn.taketoday.lang.Assert;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.CompositeBuffer;
import io.netty5.buffer.api.DefaultBufferAllocators;
import java.nio.ByteBuffer;
import java.util.List;

public class Netty5DataBufferFactory
implements DataBufferFactory {
    private final BufferAllocator bufferAllocator;

    public Netty5DataBufferFactory(BufferAllocator bufferAllocator) {
        Assert.notNull((Object)bufferAllocator, "BufferAllocator must not be null");
        this.bufferAllocator = bufferAllocator;
    }

    public BufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    @Override
    @Deprecated
    public Netty5DataBuffer allocateBuffer() {
        Buffer buffer = this.bufferAllocator.allocate(256);
        return new Netty5DataBuffer(buffer, this);
    }

    @Override
    public Netty5DataBuffer allocateBuffer(int initialCapacity) {
        Buffer buffer = this.bufferAllocator.allocate(initialCapacity);
        return new Netty5DataBuffer(buffer, this);
    }

    @Override
    public Netty5DataBuffer wrap(ByteBuffer byteBuffer) {
        Buffer buffer = this.bufferAllocator.copyOf(byteBuffer);
        return new Netty5DataBuffer(buffer, this);
    }

    @Override
    public Netty5DataBuffer wrap(byte[] bytes) {
        Buffer buffer = this.bufferAllocator.copyOf(bytes);
        return new Netty5DataBuffer(buffer, this);
    }

    public Netty5DataBuffer wrap(Buffer buffer) {
        buffer.touch((Object)"Wrap buffer");
        return new Netty5DataBuffer(buffer, this);
    }

    @Override
    public DataBuffer join(List<? extends DataBuffer> dataBuffers) {
        Assert.notEmpty(dataBuffers, "DataBuffer List must not be empty");
        if (dataBuffers.size() == 1) {
            return dataBuffers.get(0);
        }
        CompositeBuffer composite = this.bufferAllocator.compose();
        for (DataBuffer dataBuffer : dataBuffers) {
            Assert.isInstanceOf(Netty5DataBuffer.class, dataBuffer);
            composite.extendWith(((Netty5DataBuffer)dataBuffer).getNativeBuffer().send());
        }
        return new Netty5DataBuffer((Buffer)composite, this);
    }

    @Override
    public boolean isDirect() {
        return this.bufferAllocator.getAllocationType().isDirect();
    }

    public static Buffer toBuffer(DataBuffer buffer) {
        if (buffer instanceof Netty5DataBuffer) {
            Netty5DataBuffer netty5DataBuffer = (Netty5DataBuffer)buffer;
            return netty5DataBuffer.getNativeBuffer();
        }
        return DefaultBufferAllocators.preferredAllocator().copyOf(buffer.toByteBuffer());
    }

    public String toString() {
        return "Netty5DataBufferFactory (" + this.bufferAllocator + ")";
    }
}

