/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.AbstractFileResolvingResource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ResourceUtils;
import cn.taketoday.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class UrlResource
extends AbstractFileResolvingResource {
    @Nullable
    private final URI uri;
    private final URL url;
    @Nullable
    private volatile URL cleanedUrl;

    public UrlResource(URI uri) throws MalformedURLException {
        Assert.notNull((Object)uri, "URI must not be null");
        this.uri = uri;
        this.url = uri.toURL();
    }

    public UrlResource(URL url) {
        Assert.notNull((Object)url, "URL must not be null");
        this.uri = null;
        this.url = url;
    }

    public UrlResource(String path) throws MalformedURLException {
        Assert.notNull((Object)path, "Path must not be null");
        this.uri = null;
        this.url = new URL(path);
        this.cleanedUrl = UrlResource.getCleanedUrl(this.url, path);
    }

    public UrlResource(String protocol, String location) throws MalformedURLException {
        this(protocol, location, null);
    }

    public UrlResource(String protocol, String location, @Nullable String fragment) throws MalformedURLException {
        try {
            this.uri = new URI(protocol, location, fragment);
            this.url = this.uri.toURL();
        }
        catch (URISyntaxException ex) {
            MalformedURLException exToThrow = new MalformedURLException(ex.getMessage());
            exToThrow.initCause(ex);
            throw exToThrow;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection con = this.url.openConnection();
        this.customizeConnection(con);
        try {
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw ex;
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public URI getURI() throws IOException {
        if (this.uri != null) {
            return this.uri;
        }
        return super.getURI();
    }

    @Override
    public File getFile() throws IOException {
        if (this.uri != null) {
            return ResourceUtils.getFile(this.uri, this.toString());
        }
        return ResourceUtils.getFile(this.url, this.toString());
    }

    @Override
    public boolean isFile() {
        if (this.uri != null) {
            return super.isFile(this.uri);
        }
        return super.isFile();
    }

    private static URL getCleanedUrl(URL originalUrl, String originalPath) {
        String cleanedPath = StringUtils.cleanPath(originalPath);
        if (!cleanedPath.equals(originalPath)) {
            try {
                return new URL(cleanedPath);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return originalUrl;
    }

    private URL getCleanedUrl() {
        URL cleanedUrl = this.cleanedUrl;
        if (cleanedUrl != null) {
            return cleanedUrl;
        }
        this.cleanedUrl = cleanedUrl = UrlResource.getCleanedUrl(this.url, (this.uri != null ? this.uri : this.url).toString());
        return cleanedUrl;
    }

    @Override
    public String getName() {
        String filename = StringUtils.getFilename(this.getCleanedUrl().getPath());
        return URLDecoder.decode(filename, StandardCharsets.UTF_8);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof UrlResource && this.getCleanedUrl().equals(((UrlResource)other).getCleanedUrl());
    }

    @Override
    public int hashCode() {
        return this.getCleanedUrl().hashCode();
    }

    @Override
    public UrlResource createRelative(String relativePath) throws IOException {
        return new UrlResource(this.createRelativeURL(relativePath));
    }

    protected URL createRelativeURL(String relativePath) throws MalformedURLException {
        String relativePathToUse = relativePath;
        if (StringUtils.matchesFirst(relativePathToUse, '/')) {
            relativePathToUse = relativePathToUse.substring(1);
        }
        relativePathToUse = StringUtils.replace(relativePathToUse, "#", "%23");
        return new URL(this.url, relativePathToUse);
    }

    @Override
    public String toString() {
        return "URL [" + this.url + "]";
    }

    public static UrlResource from(URI uri) throws UncheckedIOException {
        try {
            return new UrlResource(uri);
        }
        catch (MalformedURLException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static UrlResource from(String path) throws UncheckedIOException {
        try {
            return new UrlResource(path);
        }
        catch (MalformedURLException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

