/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.EncodedResource;
import cn.taketoday.core.io.PropertiesUtils;
import cn.taketoday.core.io.Resource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.DefaultPropertiesPersister;
import cn.taketoday.util.PropertiesPersister;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;

public abstract class PropertiesLoaderSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    protected Properties[] localProperties;
    protected boolean localOverride = false;
    @Nullable
    private Resource[] locations;
    private boolean ignoreResourceNotFound = false;
    @Nullable
    private String fileEncoding;
    private PropertiesPersister propertiesPersister = DefaultPropertiesPersister.INSTANCE;

    public void setProperties(Properties properties) {
        this.localProperties = new Properties[]{properties};
    }

    public void setPropertiesArray(Properties ... propertiesArray) {
        this.localProperties = propertiesArray;
    }

    public void setLocation(Resource location) {
        this.locations = new Resource[]{location};
    }

    public void setLocations(Resource ... locations) {
        this.locations = locations;
    }

    public void setLocalOverride(boolean localOverride) {
        this.localOverride = localOverride;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public void setPropertiesPersister(@Nullable PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : DefaultPropertiesPersister.INSTANCE;
    }

    protected Properties mergeProperties() throws IOException {
        Properties result = new Properties();
        if (this.localOverride) {
            this.loadProperties(result);
        }
        if (this.localProperties != null) {
            for (Properties localProp : this.localProperties) {
                CollectionUtils.mergePropertiesIntoMap(localProp, result);
            }
        }
        if (!this.localOverride) {
            this.loadProperties(result);
        }
        return result;
    }

    protected void loadProperties(Properties props) throws IOException {
        if (this.locations != null) {
            for (Resource location : this.locations) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Loading properties file from {}", (Object)location);
                }
                try {
                    PropertiesUtils.fillProperties(props, new EncodedResource(location, this.fileEncoding), this.propertiesPersister);
                }
                catch (FileNotFoundException | SocketException | UnknownHostException ex) {
                    if (this.ignoreResourceNotFound) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Properties resource not found: {}", (Object)ex.getMessage());
                        continue;
                    }
                    throw ex;
                }
            }
        }
    }
}

