/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.PathMatchingPatternResourceLoader;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceConsumer;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ResourceUtils;
import java.io.IOException;
import java.util.Set;

public interface PatternResourceLoader
extends ResourceLoader {
    public static final String CLASSPATH_ALL_URL_PREFIX = "classpath*:";

    public Set<Resource> getResources(String var1) throws IOException;

    public void scan(String var1, ResourceConsumer var2) throws IOException;

    default public Resource[] getResourcesArray(String locationPattern) throws IOException {
        return this.getResources(locationPattern).toArray(Resource.EMPTY_ARRAY);
    }

    public static boolean isUrl(@Nullable String resourceLocation) {
        return resourceLocation != null && (resourceLocation.startsWith(CLASSPATH_ALL_URL_PREFIX) || ResourceUtils.isUrl(resourceLocation));
    }

    public static PatternResourceLoader fromResourceLoader(@Nullable ResourceLoader resourceLoader) {
        if (resourceLoader instanceof PatternResourceLoader) {
            return (PatternResourceLoader)resourceLoader;
        }
        if (resourceLoader != null) {
            return new PathMatchingPatternResourceLoader(resourceLoader);
        }
        return new PathMatchingPatternResourceLoader();
    }
}

