/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.JarResource;
import cn.taketoday.core.io.UrlResource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.util.ResourceUtils;
import cn.taketoday.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class JarEntryResource
extends UrlResource
implements JarResource {
    private final String entryName;
    private final File jarFile;
    private JarFile jar;

    public JarEntryResource(URL url) {
        this(url, new File(JarEntryResource.getJarFilePath(url.getPath())), JarEntryResource.getJarEntryName(url.getPath()));
    }

    public JarEntryResource(String path) throws IOException {
        this(new URL(JarEntryResource.getJarUrl(path)), new File(JarEntryResource.getJarFilePath(path)), JarEntryResource.getJarEntryName(path));
    }

    public JarEntryResource(URL url, File jarFile, String entryName) {
        super(url);
        Assert.notNull((Object)entryName, "name must not be null");
        Assert.notNull((Object)jarFile, "name must not be null");
        this.entryName = entryName;
        this.jarFile = jarFile;
    }

    JarEntryResource(URL url, File jarFile, String entryName, JarFile jar) {
        super(url);
        this.jar = jar;
        this.entryName = entryName;
        this.jarFile = jarFile;
    }

    protected static String getJarUrl(String path) {
        if (path.startsWith("jar:file:")) {
            return path;
        }
        String concat = "jar:file:".concat(path);
        if (concat.endsWith("!/")) {
            return concat;
        }
        return concat.concat("!/");
    }

    protected static String getJarFilePath(String path) {
        int indexOf = path.indexOf("!/");
        if (path.startsWith("file:")) {
            return indexOf == -1 ? path.substring(5) : path.substring(5, indexOf);
        }
        return indexOf == -1 ? path : path.substring(0, indexOf);
    }

    private static String getJarEntryName(String path) {
        int indexOf = path.indexOf("!/");
        if (indexOf == -1) {
            return "";
        }
        if (path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path.substring(indexOf + 2);
    }

    public String getEntryName() {
        return this.entryName;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.entryName.isEmpty()) {
            return new FileInputStream(this.jarFile);
        }
        JarFile jarFile = this.getJarFile();
        InputStream inputStream = jarFile.getInputStream(jarFile.getEntry(this.entryName));
        return new JarEntryInputStream(inputStream, jarFile);
    }

    @Override
    public JarOutputStream getOutputStream() throws IOException {
        return new JarOutputStream(Files.newOutputStream(this.getFile().toPath(), new OpenOption[0]));
    }

    @Override
    public File getFile() {
        return this.jarFile;
    }

    @Override
    public boolean exists() {
        boolean bl;
        block9: {
            if (this.entryName.isEmpty()) {
                return this.jarFile.exists();
            }
            JarFile jarFile = this.getJarFile();
            try {
                boolean bl2 = bl = jarFile.getEntry(this.entryName) != null;
                if (jarFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            jarFile.close();
        }
        return bl;
    }

    @Override
    public boolean isDirectory() throws IOException {
        try (JarFile jarFile = this.getJarFile();){
            boolean bl = jarFile.getEntry(this.entryName).isDirectory();
            return bl;
        }
    }

    @Override
    public String[] list() throws IOException {
        try (JarFile jarFile = this.getJarFile();){
            String[] stringArray;
            String name = this.entryName;
            HashSet<String> result = new HashSet<String>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (entryName.equals(name) || !entryName.startsWith(name)) continue;
                String substring = entryName.substring(name.length());
                int index = substring.indexOf(47);
                if (index > -1) {
                    result.add(substring.substring(0, index));
                    continue;
                }
                result.add(substring);
            }
            if (result.isEmpty()) {
                stringArray = Constant.EMPTY_STRING_ARRAY;
                return stringArray;
            }
            stringArray = StringUtils.toStringArray(result);
            return stringArray;
        }
    }

    @Override
    public JarEntryResource createRelative(String relativePath) throws IOException {
        URL url = new URL(this.getURL(), relativePath);
        String path = ResourceUtils.getRelativePath(this.entryName, relativePath);
        return new JarEntryResource(url, this.getFile(), path, this.jar);
    }

    @Override
    public String toString() {
        return "JarEntryResource: ".concat(this.getURL().toString());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof JarEntryResource) {
            return Objects.equals(((JarEntryResource)other).entryName, this.entryName) && Objects.equals(((JarEntryResource)other).jarFile, this.jarFile);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entryName, this.jarFile);
    }

    @Override
    public void close() throws Exception {
        if (this.jar != null) {
            this.jar.close();
            this.jar = null;
        }
    }

    private static class JarEntryInputStream
    extends FilterInputStream {
        private final JarFile jarFile;

        protected JarEntryInputStream(InputStream in, JarFile jarFile) {
            super(in);
            this.jarFile = jarFile;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
            this.jarFile.close();
        }
    }
}

