/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.AbstractResource;
import cn.taketoday.lang.Assert;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamResource
extends AbstractResource {
    private boolean read = false;
    private final String description;
    private final InputStream inputStream;

    public InputStreamResource(InputStream inputStream) {
        this(inputStream, "resource loaded through InputStream");
    }

    public InputStreamResource(InputStream inputStream, String description) {
        Assert.notNull((Object)inputStream, "InputStream must not be null");
        this.inputStream = inputStream;
        this.description = description != null ? description : "";
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public InputStream getInputStream() throws IOException, IllegalStateException {
        Assert.state(!this.read, "InputStream has already been read - do not use InputStreamResource if a stream needs to be read multiple times");
        this.read = true;
        return this.inputStream;
    }

    @Override
    public String toString() {
        return "InputStream resource [" + this.description + "]";
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof InputStreamResource && ((InputStreamResource)other).inputStream.equals(this.inputStream);
    }

    @Override
    public int hashCode() {
        return this.inputStream.hashCode();
    }
}

