/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.env;

import cn.taketoday.core.env.EnumerablePropertySource;
import cn.taketoday.core.env.IterablePropertyResolver;
import cn.taketoday.core.env.PropertySource;
import cn.taketoday.core.env.PropertySources;
import cn.taketoday.core.env.TypedPropertyResolver;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;

public class PropertySourcesPropertyResolver
extends TypedPropertyResolver
implements IterablePropertyResolver {
    private static final Logger log = LoggerFactory.getLogger(PropertySourcesPropertyResolver.class);
    @Nullable
    private final PropertySources propertySources;

    public PropertySourcesPropertyResolver(@Nullable PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    @Override
    public boolean containsProperty(String key) {
        if (this.propertySources != null) {
            for (PropertySource<?> propertySource : this.propertySources) {
                if (!propertySource.containsProperty(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
        boolean traceEnabled = log.isTraceEnabled();
        if (this.propertySources != null) {
            for (PropertySource<?> propertySource : this.propertySources) {
                Object value;
                if (traceEnabled) {
                    log.trace("Searching for key '{}' in PropertySource '{}'", (Object)key, (Object)propertySource.getName());
                }
                if ((value = propertySource.getProperty(key)) == null) continue;
                if (resolveNestedPlaceholders && value instanceof String) {
                    value = this.resolveNestedPlaceholders((String)value);
                }
                this.logKeyFound(key, propertySource, value);
                return this.convertValueIfNecessary(value, targetValueType);
            }
        }
        if (traceEnabled) {
            log.trace("Could not find key '{}' in any property source", (Object)key);
        }
        return null;
    }

    protected void logKeyFound(String key, PropertySource<?> propertySource, Object value) {
        if (log.isDebugEnabled()) {
            log.debug("Found key '{}' in PropertySource '{}' with value of type {}", key, propertySource.getName(), value.getClass().getSimpleName());
        }
    }

    public ArrayList<String> getPropertyNames() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.propertySources != null) {
            for (PropertySource<?> propertySource : this.propertySources) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                Object[] propertyNames = enumerablePropertySource.getPropertyNames();
                CollectionUtils.addAll(ret, propertyNames);
            }
        }
        return ret;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getPropertyNames().iterator();
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        for (String key : this.getPropertyNames()) {
            action.accept(key);
        }
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.getPropertyNames().spliterator();
    }
}

