/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.env;

import cn.taketoday.core.env.IterablePropertyResolver;
import cn.taketoday.core.env.PropertyResolver;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CompositeIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PropertyResolverComposite
implements PropertyResolver,
IterablePropertyResolver {
    private final List<PropertyResolver> resolverList;

    public PropertyResolverComposite(PropertyResolver ... resolvers) {
        this.resolverList = Arrays.asList(resolvers);
    }

    public PropertyResolverComposite(List<PropertyResolver> resolverList) {
        this.resolverList = resolverList;
    }

    @Override
    public boolean containsProperty(String key) {
        for (PropertyResolver propertyResolver : this.resolverList) {
            if (!propertyResolver.containsProperty(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getProperty(String key) {
        for (PropertyResolver propertyResolver : this.resolverList) {
            String property = propertyResolver.getProperty(key);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        for (PropertyResolver propertyResolver : this.resolverList) {
            String property = propertyResolver.getProperty(key, (String)null);
            if (property == null) continue;
            return property;
        }
        return defaultValue;
    }

    @Override
    @Nullable
    public <T> T getProperty(String key, Class<T> targetType) {
        for (PropertyResolver propertyResolver : this.resolverList) {
            T property = propertyResolver.getProperty(key, targetType);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        for (PropertyResolver propertyResolver : this.resolverList) {
            T property = propertyResolver.getProperty(key, targetType);
            if (property == null) continue;
            return property;
        }
        return defaultValue;
    }

    @Override
    public String getRequiredProperty(String key) throws IllegalStateException {
        for (PropertyResolver propertyResolver : this.resolverList) {
            String property = propertyResolver.getProperty(key);
            if (property == null) continue;
            return property;
        }
        throw new IllegalStateException("Required key '" + key + "' not found");
    }

    @Override
    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        for (PropertyResolver propertyResolver : this.resolverList) {
            T property = propertyResolver.getProperty(key, targetType);
            if (property == null) continue;
            return property;
        }
        throw new IllegalStateException("Required key '" + key + "' not found");
    }

    @Override
    public String resolvePlaceholders(String text) {
        for (PropertyResolver propertyResolver : this.resolverList) {
            text = propertyResolver.resolvePlaceholders(text);
        }
        return text;
    }

    @Override
    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        for (PropertyResolver propertyResolver : this.resolverList) {
            text = propertyResolver.resolveRequiredPlaceholders(text);
        }
        return text;
    }

    @Override
    public Iterator<String> iterator() {
        CompositeIterator<String> iterator = new CompositeIterator<String>();
        for (PropertyResolver propertyResolver : this.resolverList) {
            if (!(propertyResolver instanceof IterablePropertyResolver)) continue;
            iterator.add(((IterablePropertyResolver)propertyResolver).iterator());
        }
        return iterator;
    }
}

