/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.env;

import cn.taketoday.core.conversion.support.ConfigurableConversionService;
import cn.taketoday.core.conversion.support.DefaultConversionService;
import cn.taketoday.core.env.ConfigurablePropertyResolver;
import cn.taketoday.core.env.MissingRequiredPropertiesException;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.PlaceholderResolver;
import cn.taketoday.util.PropertyPlaceholderHandler;
import java.util.Collections;
import java.util.LinkedHashSet;

public abstract class AbstractPropertyResolver
implements ConfigurablePropertyResolver,
PlaceholderResolver {
    @Nullable
    private volatile ConfigurableConversionService conversionService;
    @Nullable
    private PropertyPlaceholderHandler nonStrictHelper;
    @Nullable
    private PropertyPlaceholderHandler strictHelper;
    private boolean ignoreUnresolvableNestedPlaceholders = false;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    @Nullable
    private String valueSeparator = ":";
    @Nullable
    private LinkedHashSet<String> requiredProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableConversionService getConversionService() {
        ConfigurableConversionService cs = this.conversionService;
        if (cs == null) {
            AbstractPropertyResolver abstractPropertyResolver = this;
            synchronized (abstractPropertyResolver) {
                cs = this.conversionService;
                if (cs == null) {
                    this.conversionService = cs = new DefaultConversionService();
                }
            }
        }
        return cs;
    }

    @Override
    public void setConversionService(ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public void setPlaceholderPrefix(String placeholderPrefix) {
        Assert.notNull((Object)placeholderPrefix, "'placeholderPrefix' must not be null");
        this.placeholderPrefix = placeholderPrefix;
    }

    @Override
    public void setPlaceholderSuffix(String placeholderSuffix) {
        Assert.notNull((Object)placeholderSuffix, "'placeholderSuffix' must not be null");
        this.placeholderSuffix = placeholderSuffix;
    }

    @Override
    public void setValueSeparator(@Nullable String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    @Override
    public void setIgnoreUnresolvableNestedPlaceholders(boolean ignoreUnresolvableNestedPlaceholders) {
        this.ignoreUnresolvableNestedPlaceholders = ignoreUnresolvableNestedPlaceholders;
    }

    @Override
    public void setRequiredProperties(String ... requiredProperties) {
        if (this.requiredProperties == null) {
            this.requiredProperties = new LinkedHashSet();
        } else {
            this.requiredProperties.clear();
        }
        Collections.addAll(this.requiredProperties, requiredProperties);
    }

    @Override
    public void addRequiredProperties(String ... requiredProperties) {
        if (this.requiredProperties == null) {
            this.requiredProperties = new LinkedHashSet();
        }
        Collections.addAll(this.requiredProperties, requiredProperties);
    }

    @Override
    public void validateRequiredProperties() {
        if (CollectionUtils.isNotEmpty(this.requiredProperties)) {
            LinkedHashSet<String> missingRequiredProperties = new LinkedHashSet<String>();
            for (String key : this.requiredProperties) {
                if (this.getProperty(key) != null) continue;
                missingRequiredProperties.add(key);
            }
            if (!missingRequiredProperties.isEmpty()) {
                throw new MissingRequiredPropertiesException(missingRequiredProperties);
            }
        }
    }

    @Override
    public boolean containsProperty(String key) {
        return this.getProperty(key) != null;
    }

    @Override
    @Nullable
    public String getProperty(String key) {
        return this.getProperty(key, String.class);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        T value = this.getProperty(key, targetType);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getRequiredProperty(String key) throws IllegalStateException {
        String value = this.getProperty(key);
        if (value == null) {
            throw new IllegalStateException("Required key '" + key + "' not found");
        }
        return value;
    }

    @Override
    public <T> T getRequiredProperty(String key, Class<T> valueType) throws IllegalStateException {
        T value = this.getProperty(key, valueType);
        if (value == null) {
            throw new IllegalStateException("Required key '" + key + "' not found");
        }
        return value;
    }

    @Override
    public String resolvePlaceholders(String text) {
        if (this.nonStrictHelper == null) {
            this.nonStrictHelper = this.createPlaceholderHelper(true);
        }
        return this.nonStrictHelper.replacePlaceholders(text, this);
    }

    @Override
    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        if (this.strictHelper == null) {
            this.strictHelper = this.createPlaceholderHelper(false);
        }
        return this.strictHelper.replacePlaceholders(text, this);
    }

    protected String resolveNestedPlaceholders(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return this.ignoreUnresolvableNestedPlaceholders ? this.resolvePlaceholders(value) : this.resolveRequiredPlaceholders(value);
    }

    private PropertyPlaceholderHandler createPlaceholderHelper(boolean ignoreUnresolvablePlaceholders) {
        return new PropertyPlaceholderHandler(this.placeholderPrefix, this.placeholderSuffix, this.valueSeparator, ignoreUnresolvablePlaceholders);
    }

    @Override
    @Nullable
    public String resolvePlaceholder(String placeholderName) {
        return this.getPropertyAsRawString(placeholderName);
    }

    @Nullable
    protected <T> T convertValueIfNecessary(Object value, @Nullable Class<T> targetType) {
        if (targetType == null || ClassUtils.isAssignableValue(targetType, value)) {
            return (T)value;
        }
        ConfigurableConversionService conversionServiceToUse = this.conversionService;
        if (conversionServiceToUse == null) {
            conversionServiceToUse = DefaultConversionService.getSharedInstance();
        }
        return conversionServiceToUse.convert(value, targetType);
    }

    @Nullable
    protected abstract String getPropertyAsRawString(String var1);
}

