/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.env;

import cn.taketoday.core.conversion.support.ConfigurableConversionService;
import cn.taketoday.core.env.ConfigurableEnvironment;
import cn.taketoday.core.env.ConfigurablePropertyResolver;
import cn.taketoday.core.env.IterablePropertyResolver;
import cn.taketoday.core.env.MissingRequiredPropertiesException;
import cn.taketoday.core.env.Profiles;
import cn.taketoday.core.env.PropertySource;
import cn.taketoday.core.env.PropertySources;
import cn.taketoday.core.env.PropertySourcesPropertyResolver;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.lang.TodayStrategies;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEnvironment
implements ConfigurableEnvironment,
IterablePropertyResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractEnvironment.class);
    private final LinkedHashSet<String> activeProfiles = new LinkedHashSet();
    private final LinkedHashSet<String> defaultProfiles = new LinkedHashSet<String>(this.getReservedDefaultProfiles());
    private final PropertySources propertySources;
    private final ConfigurablePropertyResolver propertyResolver;

    public AbstractEnvironment() {
        this(new PropertySources());
    }

    protected AbstractEnvironment(PropertySources propertySources) {
        this.propertySources = propertySources;
        this.propertyResolver = this.createPropertyResolver(propertySources);
        this.customizePropertySources(propertySources);
    }

    protected ConfigurablePropertyResolver createPropertyResolver(PropertySources propertySources) {
        return new PropertySourcesPropertyResolver(propertySources);
    }

    protected final ConfigurablePropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    protected void customizePropertySources(PropertySources propertySources) {
    }

    protected Set<String> getReservedDefaultProfiles() {
        return Collections.singleton("default");
    }

    @Override
    public String[] getActiveProfiles() {
        return StringUtils.toStringArray(this.doGetActiveProfiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> doGetActiveProfiles() {
        LinkedHashSet<String> linkedHashSet = this.activeProfiles;
        synchronized (linkedHashSet) {
            String profiles;
            if (this.activeProfiles.isEmpty() && StringUtils.hasText(profiles = this.doGetActiveProfilesProperty())) {
                this.setActiveProfiles(StringUtils.commaDelimitedListToStringArray(StringUtils.trimAllWhitespace(profiles)));
            }
            return this.activeProfiles;
        }
    }

    @Nullable
    protected String doGetActiveProfilesProperty() {
        return this.getProperty("context.profiles.active");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveProfiles(String ... profiles) {
        Assert.notNull((Object)profiles, "Profile array must not be null");
        if (log.isDebugEnabled()) {
            log.debug("Activating profiles {}", (Object)Arrays.asList(profiles));
        }
        LinkedHashSet<String> linkedHashSet = this.activeProfiles;
        synchronized (linkedHashSet) {
            this.activeProfiles.clear();
            for (String profile : profiles) {
                this.validateProfile(profile);
                this.activeProfiles.add(profile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActiveProfile(String profile) {
        log.debug("Activating profile '{}'", (Object)profile);
        this.validateProfile(profile);
        this.doGetActiveProfiles();
        LinkedHashSet<String> linkedHashSet = this.activeProfiles;
        synchronized (linkedHashSet) {
            this.activeProfiles.add(profile);
        }
    }

    @Override
    public String[] getDefaultProfiles() {
        return StringUtils.toStringArray(this.doGetDefaultProfiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> doGetDefaultProfiles() {
        LinkedHashSet<String> linkedHashSet = this.defaultProfiles;
        synchronized (linkedHashSet) {
            String profiles;
            if (this.defaultProfiles.equals(this.getReservedDefaultProfiles()) && StringUtils.hasText(profiles = this.doGetDefaultProfilesProperty())) {
                this.setDefaultProfiles(StringUtils.commaDelimitedListToStringArray(StringUtils.trimAllWhitespace(profiles)));
            }
            return this.defaultProfiles;
        }
    }

    @Nullable
    protected String doGetDefaultProfilesProperty() {
        return this.getProperty("context.profiles.default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultProfiles(String ... profiles) {
        Assert.notNull((Object)profiles, "Profile array must not be null");
        LinkedHashSet<String> linkedHashSet = this.defaultProfiles;
        synchronized (linkedHashSet) {
            this.defaultProfiles.clear();
            for (String profile : profiles) {
                this.validateProfile(profile);
                this.defaultProfiles.add(profile);
            }
        }
    }

    @Override
    public boolean acceptsProfiles(Profiles profiles) {
        Assert.notNull((Object)profiles, "Profiles must not be null");
        return profiles.matches(this::isProfileActive);
    }

    protected boolean isProfileActive(String profile) {
        this.validateProfile(profile);
        Set<String> currentActiveProfiles = this.doGetActiveProfiles();
        return currentActiveProfiles.contains(profile) || currentActiveProfiles.isEmpty() && this.doGetDefaultProfiles().contains(profile);
    }

    protected void validateProfile(String profile) {
        if (!StringUtils.hasText(profile)) {
            throw new IllegalArgumentException("Invalid profile [" + profile + "]: must contain text");
        }
        if (profile.charAt(0) == '!') {
            throw new IllegalArgumentException("Invalid profile [" + profile + "]: must not begin with ! operator");
        }
    }

    @Override
    public PropertySources getPropertySources() {
        return this.propertySources;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        return System.getProperties();
    }

    @Override
    public Map<String, Object> getSystemEnvironment() {
        if (this.suppressGetenvAccess()) {
            return Collections.emptyMap();
        }
        return System.getenv();
    }

    protected boolean suppressGetenvAccess() {
        return TodayStrategies.getFlag("context.getenv.ignore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(ConfigurableEnvironment parent) {
        Object[] parentDefaultProfiles;
        for (PropertySource<?> ps : parent.getPropertySources()) {
            if (this.propertySources.contains(ps.getName())) continue;
            this.propertySources.addLast(ps);
        }
        Object[] parentActiveProfiles = parent.getActiveProfiles();
        if (ObjectUtils.isNotEmpty(parentActiveProfiles)) {
            PropertySource<?> ps;
            ps = this.activeProfiles;
            synchronized (ps) {
                Collections.addAll(this.activeProfiles, parentActiveProfiles);
            }
        }
        if (ObjectUtils.isNotEmpty(parentDefaultProfiles = parent.getDefaultProfiles())) {
            LinkedHashSet<String> linkedHashSet = this.defaultProfiles;
            synchronized (linkedHashSet) {
                this.defaultProfiles.remove("default");
                Collections.addAll(this.defaultProfiles, parentDefaultProfiles);
            }
        }
    }

    @Override
    public ConfigurableConversionService getConversionService() {
        return this.propertyResolver.getConversionService();
    }

    @Override
    public void setConversionService(ConfigurableConversionService conversionService) {
        this.propertyResolver.setConversionService(conversionService);
    }

    @Override
    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.propertyResolver.setPlaceholderPrefix(placeholderPrefix);
    }

    @Override
    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.propertyResolver.setPlaceholderSuffix(placeholderSuffix);
    }

    @Override
    public void setValueSeparator(@Nullable String valueSeparator) {
        this.propertyResolver.setValueSeparator(valueSeparator);
    }

    @Override
    public void setIgnoreUnresolvableNestedPlaceholders(boolean ignoreUnresolvableNestedPlaceholders) {
        this.propertyResolver.setIgnoreUnresolvableNestedPlaceholders(ignoreUnresolvableNestedPlaceholders);
    }

    @Override
    public void setRequiredProperties(String ... requiredProperties) {
        this.propertyResolver.setRequiredProperties(requiredProperties);
    }

    @Override
    public void addRequiredProperties(String ... requiredProperties) {
        this.propertyResolver.addRequiredProperties(requiredProperties);
    }

    @Override
    public void validateRequiredProperties() throws MissingRequiredPropertiesException {
        this.propertyResolver.validateRequiredProperties();
    }

    @Override
    public boolean containsProperty(String key) {
        return this.propertyResolver.containsProperty(key);
    }

    @Override
    @Nullable
    public String getProperty(String key) {
        return this.propertyResolver.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.propertyResolver.getProperty(key, defaultValue);
    }

    @Override
    @Nullable
    public <T> T getProperty(String key, Class<T> targetType) {
        return this.propertyResolver.getProperty(key, targetType);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return this.propertyResolver.getProperty(key, targetType, defaultValue);
    }

    @Override
    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(key);
    }

    @Override
    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(key, targetType);
    }

    @Override
    public String resolvePlaceholders(String text) {
        return this.propertyResolver.resolvePlaceholders(text);
    }

    @Override
    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return this.propertyResolver.resolveRequiredPlaceholders(text);
    }

    @Override
    public Iterator<String> iterator() {
        if (this.propertyResolver instanceof IterablePropertyResolver) {
            return ((IterablePropertyResolver)((Object)this.propertyResolver)).iterator();
        }
        return Collections.emptyIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {activeProfiles=" + this.activeProfiles + ", defaultProfiles=" + this.defaultProfiles + ", propertySources=" + this.propertySources + "}";
    }
}

