/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion.support;

import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.conversion.ConverterFactory;
import cn.taketoday.util.ClassUtils;

final class IntegerToEnumConverterFactory
implements ConverterFactory<Integer, Enum> {
    IntegerToEnumConverterFactory() {
    }

    @Override
    public <T extends Enum> Converter<Integer, T> getConverter(Class<T> targetType) {
        return new IntegerToEnum(ClassUtils.getEnumType(targetType));
    }

    private record IntegerToEnum<T extends Enum>(Class<T> enumType) implements Converter<Integer, T>
    {
        @Override
        public T convert(Integer source) {
            return (T)((Enum[])this.enumType.getEnumConstants())[source];
        }
    }
}

