/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion.support;

import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.conversion.ConverterRegistry;
import cn.taketoday.core.conversion.support.ArrayToArrayConverter;
import cn.taketoday.core.conversion.support.ArrayToCollectionConverter;
import cn.taketoday.core.conversion.support.ArrayToObjectConverter;
import cn.taketoday.core.conversion.support.ArrayToStringConverter;
import cn.taketoday.core.conversion.support.ByteBufferConverter;
import cn.taketoday.core.conversion.support.CharacterToNumberFactory;
import cn.taketoday.core.conversion.support.CollectionToArrayConverter;
import cn.taketoday.core.conversion.support.CollectionToCollectionConverter;
import cn.taketoday.core.conversion.support.CollectionToObjectConverter;
import cn.taketoday.core.conversion.support.CollectionToStringConverter;
import cn.taketoday.core.conversion.support.EnumToIntegerConverter;
import cn.taketoday.core.conversion.support.EnumToStringConverter;
import cn.taketoday.core.conversion.support.FallbackObjectToStringConverter;
import cn.taketoday.core.conversion.support.GenericConversionService;
import cn.taketoday.core.conversion.support.IdToEntityConverter;
import cn.taketoday.core.conversion.support.IntegerToEnumConverterFactory;
import cn.taketoday.core.conversion.support.MapToMapConverter;
import cn.taketoday.core.conversion.support.NumberToCharacterConverter;
import cn.taketoday.core.conversion.support.NumberToNumberConverterFactory;
import cn.taketoday.core.conversion.support.ObjectToArrayConverter;
import cn.taketoday.core.conversion.support.ObjectToCollectionConverter;
import cn.taketoday.core.conversion.support.ObjectToObjectConverter;
import cn.taketoday.core.conversion.support.ObjectToOptionalConverter;
import cn.taketoday.core.conversion.support.ObjectToStringConverter;
import cn.taketoday.core.conversion.support.PropertiesToStringConverter;
import cn.taketoday.core.conversion.support.StreamConverter;
import cn.taketoday.core.conversion.support.StringToArrayConverter;
import cn.taketoday.core.conversion.support.StringToBooleanConverter;
import cn.taketoday.core.conversion.support.StringToCharacterConverter;
import cn.taketoday.core.conversion.support.StringToCharsetConverter;
import cn.taketoday.core.conversion.support.StringToCollectionConverter;
import cn.taketoday.core.conversion.support.StringToCurrencyConverter;
import cn.taketoday.core.conversion.support.StringToEnumConverterFactory;
import cn.taketoday.core.conversion.support.StringToLocaleConverter;
import cn.taketoday.core.conversion.support.StringToNumberConverterFactory;
import cn.taketoday.core.conversion.support.StringToPropertiesConverter;
import cn.taketoday.core.conversion.support.StringToTimeZoneConverter;
import cn.taketoday.core.conversion.support.StringToUUIDConverter;
import cn.taketoday.core.conversion.support.ZoneIdToTimeZoneConverter;
import cn.taketoday.core.conversion.support.ZonedDateTimeToCalendarConverter;
import cn.taketoday.lang.Nullable;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.Locale;
import java.util.UUID;

public class DefaultConversionService
extends GenericConversionService {
    @Nullable
    private static volatile DefaultConversionService sharedInstance;

    public DefaultConversionService() {
        DefaultConversionService.addDefaultConverters(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultConversionService getSharedInstance() {
        DefaultConversionService cs = sharedInstance;
        if (cs != null) return cs;
        Class<DefaultConversionService> clazz = DefaultConversionService.class;
        synchronized (DefaultConversionService.class) {
            cs = sharedInstance;
            if (cs != null) return cs;
            sharedInstance = cs = new DefaultConversionService();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cs;
        }
    }

    public static void addDefaultConverters(ConverterRegistry converterRegistry) {
        DefaultConversionService.addScalarConverters(converterRegistry);
        DefaultConversionService.addCollectionConverters(converterRegistry);
        converterRegistry.addConverter(new ByteBufferConverter((ConversionService)((Object)converterRegistry)));
        converterRegistry.addConverter(new StringToTimeZoneConverter());
        converterRegistry.addConverter(new ZoneIdToTimeZoneConverter());
        converterRegistry.addConverter(new ZonedDateTimeToCalendarConverter());
        converterRegistry.addConverter(new ObjectToObjectConverter());
        converterRegistry.addConverter(new IdToEntityConverter((ConversionService)((Object)converterRegistry)));
        converterRegistry.addConverter(new FallbackObjectToStringConverter());
        converterRegistry.addConverter(new ObjectToOptionalConverter((ConversionService)((Object)converterRegistry)));
    }

    public static void addCollectionConverters(ConverterRegistry converterRegistry) {
        ConversionService conversionService = (ConversionService)((Object)converterRegistry);
        converterRegistry.addConverter(new ArrayToCollectionConverter(conversionService));
        converterRegistry.addConverter(new CollectionToArrayConverter(conversionService));
        converterRegistry.addConverter(new ArrayToArrayConverter(conversionService));
        converterRegistry.addConverter(new CollectionToCollectionConverter(conversionService));
        converterRegistry.addConverter(new MapToMapConverter(conversionService));
        converterRegistry.addConverter(new ArrayToStringConverter(conversionService));
        converterRegistry.addConverter(new StringToArrayConverter(conversionService));
        converterRegistry.addConverter(new ArrayToObjectConverter(conversionService));
        converterRegistry.addConverter(new ObjectToArrayConverter(conversionService));
        converterRegistry.addConverter(new CollectionToStringConverter(conversionService));
        converterRegistry.addConverter(new StringToCollectionConverter(conversionService));
        converterRegistry.addConverter(new CollectionToObjectConverter(conversionService));
        converterRegistry.addConverter(new ObjectToCollectionConverter(conversionService));
        converterRegistry.addConverter(new StreamConverter(conversionService));
    }

    private static void addScalarConverters(ConverterRegistry converterRegistry) {
        converterRegistry.addConverterFactory(new NumberToNumberConverterFactory());
        converterRegistry.addConverterFactory(new StringToNumberConverterFactory());
        converterRegistry.addConverter(Number.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverter(new StringToCharacterConverter());
        converterRegistry.addConverter(Character.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverter(new NumberToCharacterConverter());
        converterRegistry.addConverterFactory(new CharacterToNumberFactory());
        converterRegistry.addConverter(new StringToBooleanConverter());
        converterRegistry.addConverter(Boolean.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverterFactory(new StringToEnumConverterFactory());
        converterRegistry.addConverter(new EnumToStringConverter((ConversionService)((Object)converterRegistry)));
        converterRegistry.addConverterFactory(new IntegerToEnumConverterFactory());
        converterRegistry.addConverter(new EnumToIntegerConverter((ConversionService)((Object)converterRegistry)));
        converterRegistry.addConverter(new StringToLocaleConverter());
        converterRegistry.addConverter(Locale.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverter(new StringToCharsetConverter());
        converterRegistry.addConverter(Charset.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverter(new StringToCurrencyConverter());
        converterRegistry.addConverter(Currency.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverter(new StringToPropertiesConverter());
        converterRegistry.addConverter(new PropertiesToStringConverter());
        converterRegistry.addConverter(new StringToUUIDConverter());
        converterRegistry.addConverter(UUID.class, String.class, new ObjectToStringConverter());
    }
}

