/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion.support;

import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.conversion.ConverterFactory;
import cn.taketoday.util.NumberUtils;

final class CharacterToNumberFactory
implements ConverterFactory<Character, Number> {
    CharacterToNumberFactory() {
    }

    @Override
    public <T extends Number> Converter<Character, T> getConverter(Class<T> targetType) {
        return new CharacterToNumber<T>(targetType);
    }

    private record CharacterToNumber<T extends Number>(Class<T> targetType) implements Converter<Character, T>
    {
        @Override
        public T convert(Character source) {
            return NumberUtils.convertNumberToTargetClass((short)source.charValue(), this.targetType);
        }
    }
}

