/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConditionalConverter;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.util.ClassUtils;

abstract class AbstractConditionalEnumConverter
implements ConditionalConverter {
    private final ConversionService conversionService;

    protected AbstractConditionalEnumConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        for (Class<?> interfaceType : ClassUtils.getAllInterfacesForClassAsSet(sourceType.getType())) {
            if (!this.conversionService.canConvert(TypeDescriptor.valueOf(interfaceType), targetType)) continue;
            return false;
        }
        return true;
    }
}

