/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.Set;

public interface GenericConverter {
    @Nullable
    public Set<ConvertiblePair> getConvertibleTypes();

    @Nullable
    public Object convert(@Nullable Object var1, TypeDescriptor var2, TypeDescriptor var3);

    public record ConvertiblePair(Class<?> sourceType, Class<?> targetType) {
        public ConvertiblePair {
            Assert.notNull(sourceType, "Source type must not be null");
            Assert.notNull(targetType, "Target type must not be null");
        }

        public Class<?> getSourceType() {
            return this.sourceType;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ConvertiblePair) {
                ConvertiblePair otherPair = (ConvertiblePair)other;
                return this.sourceType == otherPair.sourceType && this.targetType == otherPair.targetType;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.sourceType.hashCode() * 31 + this.targetType.hashCode();
        }

        @Override
        public String toString() {
            return this.sourceType.getName() + " -> " + this.targetType.getName();
        }
    }
}

