/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.codec;

import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.codec.AbstractSingleValueEncoder;
import cn.taketoday.core.codec.Hints;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.buffer.DataBuffer;
import cn.taketoday.core.io.buffer.DataBufferFactory;
import cn.taketoday.core.io.buffer.DataBufferUtils;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.MimeType;
import cn.taketoday.util.MimeTypeUtils;
import java.util.Map;
import reactor.core.publisher.Flux;

public class ResourceEncoder
extends AbstractSingleValueEncoder<Resource> {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final int bufferSize;

    public ResourceEncoder() {
        this(8192);
    }

    public ResourceEncoder(int bufferSize) {
        super(MimeTypeUtils.APPLICATION_OCTET_STREAM, MimeTypeUtils.ALL);
        Assert.isTrue(bufferSize > 0, "'bufferSize' must be larger than 0");
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class<?> clazz = elementType.toClass();
        return super.canEncode(elementType, mimeType) && Resource.class.isAssignableFrom(clazz);
    }

    @Override
    protected Flux<DataBuffer> encode(Resource resource, DataBufferFactory bufferFactory, ResolvableType type, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(hints)) {
            this.logger.debug("{}Writing [{}]", (Object)Hints.getLogPrefix(hints), (Object)resource);
        }
        return DataBufferUtils.read(resource, bufferFactory, this.bufferSize);
    }
}

