/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.codec;

import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.codec.Encoder;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.MimeType;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractEncoder<T>
implements Encoder<T> {
    private final List<MimeType> encodableMimeTypes;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractEncoder(MimeType ... supportedMimeTypes) {
        this.encodableMimeTypes = Arrays.asList(supportedMimeTypes);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public List<MimeType> getEncodableMimeTypes() {
        return this.encodableMimeTypes;
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        if (mimeType == null) {
            return true;
        }
        for (MimeType candidate : this.encodableMimeTypes) {
            if (!candidate.isCompatibleWith(mimeType)) continue;
            return true;
        }
        return false;
    }
}

