/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.annotation;

import cn.taketoday.core.annotation.AbstractMergedAnnotation;
import cn.taketoday.core.annotation.AnnotationTypeMapping;
import cn.taketoday.core.annotation.AnnotationTypeMappings;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.core.annotation.IntrospectionFailureLogger;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.SynthesizedMergedAnnotationInvocationHandler;
import cn.taketoday.core.annotation.ValueExtractor;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

final class TypeMappedAnnotation<A extends Annotation>
extends AbstractMergedAnnotation<A> {
    private static final Map<Class<?>, Object> EMPTY_ARRAYS = Map.of(Boolean.TYPE, new boolean[0], Byte.TYPE, Constant.EMPTY_BYTES, Character.TYPE, new char[0], Double.TYPE, new double[0], Float.TYPE, new float[0], Integer.TYPE, Constant.EMPTY_INT_ARRAY, Long.TYPE, new long[0], Short.TYPE, new short[0], String.class, Constant.EMPTY_STRING_ARRAY);
    private final AnnotationTypeMapping mapping;
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final Object source;
    @Nullable
    private final Object rootAttributes;
    private final ValueExtractor valueExtractor;
    private final int aggregateIndex;
    private final boolean useMergedValues;
    @Nullable
    private final Predicate<String> attributeFilter;
    private final int[] resolvedRootMirrors;
    private final int[] resolvedMirrors;

    private TypeMappedAnnotation(AnnotationTypeMapping mapping, @Nullable ClassLoader classLoader, @Nullable Object source, @Nullable Object rootAttributes, ValueExtractor valueExtractor, int aggregateIndex) {
        this(mapping, classLoader, source, rootAttributes, valueExtractor, aggregateIndex, null);
    }

    private TypeMappedAnnotation(AnnotationTypeMapping mapping, @Nullable ClassLoader classLoader, @Nullable Object source, @Nullable Object rootAttributes, ValueExtractor valueExtractor, int aggregateIndex, @Nullable int[] resolvedRootMirrors) {
        this.mapping = mapping;
        this.classLoader = classLoader;
        this.source = source;
        this.rootAttributes = rootAttributes;
        this.valueExtractor = valueExtractor;
        this.aggregateIndex = aggregateIndex;
        this.useMergedValues = true;
        this.attributeFilter = null;
        this.resolvedRootMirrors = resolvedRootMirrors != null ? resolvedRootMirrors : mapping.root.mirrorSets.resolve(source, rootAttributes, valueExtractor);
        this.resolvedMirrors = this.getDistance() == 0 ? resolvedRootMirrors : mapping.mirrorSets.resolve(source, this, this::getValueForMirrorResolution);
    }

    private TypeMappedAnnotation(AnnotationTypeMapping mapping, @Nullable ClassLoader classLoader, @Nullable Object source, @Nullable Object rootAnnotation, ValueExtractor valueExtractor, int aggregateIndex, boolean useMergedValues, @Nullable Predicate<String> attributeFilter, int[] resolvedRootMirrors, int[] resolvedMirrors) {
        this.classLoader = classLoader;
        this.source = source;
        this.rootAttributes = rootAnnotation;
        this.valueExtractor = valueExtractor;
        this.mapping = mapping;
        this.aggregateIndex = aggregateIndex;
        this.useMergedValues = useMergedValues;
        this.attributeFilter = attributeFilter;
        this.resolvedRootMirrors = resolvedRootMirrors;
        this.resolvedMirrors = resolvedMirrors;
    }

    @Override
    public Class<A> getType() {
        return this.mapping.annotationType;
    }

    @Override
    public List<Class<? extends Annotation>> getMetaTypes() {
        return this.mapping.metaTypes;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public int getDistance() {
        return this.mapping.distance;
    }

    @Override
    public int getAggregateIndex() {
        return this.aggregateIndex;
    }

    @Override
    @Nullable
    public Object getSource() {
        return this.source;
    }

    @Override
    @Nullable
    public MergedAnnotation<?> getMetaSource() {
        AnnotationTypeMapping metaSourceMapping = this.mapping.source;
        if (metaSourceMapping == null) {
            return null;
        }
        return new TypeMappedAnnotation<A>(metaSourceMapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, this.resolvedRootMirrors);
    }

    @Override
    public MergedAnnotation<?> getRoot() {
        if (this.getDistance() == 0) {
            return this;
        }
        return new TypeMappedAnnotation<A>(this.mapping.root, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, this.resolvedRootMirrors);
    }

    @Override
    public boolean hasDefaultValue(String attributeName) {
        int attributeIndex = this.getAttributeIndex(attributeName, true);
        Object value = this.getValue(attributeIndex, true, false);
        return value == null || this.mapping.isEquivalentToDefaultValue(attributeIndex, value, this.valueExtractor);
    }

    @Override
    public <T extends Annotation> MergedAnnotation<T> getAnnotation(String attributeName, Class<T> type) throws NoSuchElementException {
        Assert.notNull(type, "Type must not be null");
        int attributeIndex = this.getAttributeIndex(attributeName, true);
        Method attribute = this.mapping.methods.get(attributeIndex);
        if (!type.isAssignableFrom(attribute.getReturnType())) {
            throw new IllegalArgumentException("Attribute " + attributeName + " type mismatch:");
        }
        return (MergedAnnotation)this.getRequiredValue(attributeIndex, attributeName);
    }

    @Override
    public <T extends Annotation> MergedAnnotation<T>[] getAnnotationArray(String attributeName, Class<T> type) throws NoSuchElementException {
        Assert.notNull(type, "Type must not be null");
        int attributeIndex = this.getAttributeIndex(attributeName, true);
        Method attribute = this.mapping.methods.get(attributeIndex);
        Class<?> componentType = attribute.getReturnType().getComponentType();
        if (componentType == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " is not an array");
        }
        if (!type.isAssignableFrom(componentType)) {
            throw new IllegalArgumentException("Attribute " + attributeName + " component type mismatch:");
        }
        return (MergedAnnotation[])this.getRequiredValue(attributeIndex, attributeName);
    }

    @Override
    public <T> Optional<T> getDefaultValue(String attributeName, Class<T> type) {
        int attributeIndex = this.getAttributeIndex(attributeName, false);
        if (attributeIndex == -1) {
            return Optional.empty();
        }
        Method attribute = this.mapping.methods.get(attributeIndex);
        return Optional.ofNullable(this.adapt(attribute, attribute.getDefaultValue(), type));
    }

    @Override
    public MergedAnnotation<A> filterAttributes(Predicate<String> predicate) {
        if (this.attributeFilter != null) {
            predicate = this.attributeFilter.and(predicate);
        }
        return new TypeMappedAnnotation<A>(this.mapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, this.useMergedValues, predicate, this.resolvedRootMirrors, this.resolvedMirrors);
    }

    @Override
    public MergedAnnotation<A> withNonMergedAttributes() {
        return new TypeMappedAnnotation<A>(this.mapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, false, this.attributeFilter, this.resolvedRootMirrors, this.resolvedMirrors);
    }

    @Override
    public Map<String, Object> asMap(MergedAnnotation.Adapt ... adaptations) {
        return Collections.unmodifiableMap(this.asMap((MergedAnnotation<?> mergedAnnotation) -> new LinkedHashMap(), adaptations));
    }

    @Override
    public <T extends Map<String, Object>> T asMap(Function<MergedAnnotation<?>, T> factory, MergedAnnotation.Adapt ... adaptations) {
        Map map = (Map)factory.apply(this);
        Assert.state(map != null, "Factory used to create MergedAnnotation Map must not return null");
        Method[] attributes = this.mapping.methods.attributes;
        for (int i = 0; i < attributes.length; ++i) {
            Object value;
            Method attribute = attributes[i];
            Object v0 = value = this.isFiltered(attribute.getName()) ? null : this.getValue(i, this.getTypeForMapOptions(attribute, adaptations));
            if (value == null) continue;
            map.put(attribute.getName(), this.adaptValueForMapOptions(attribute, value, map.getClass(), factory, adaptations));
        }
        return (T)map;
    }

    private Class<?> getTypeForMapOptions(Method attribute, MergedAnnotation.Adapt[] adaptations) {
        Class<?> componentType;
        Class<?> attributeType = attribute.getReturnType();
        Class<?> clazz = componentType = attributeType.isArray() ? attributeType.getComponentType() : attributeType;
        if (MergedAnnotation.Adapt.CLASS_TO_STRING.containsIn(adaptations) && componentType == Class.class) {
            return attributeType.isArray() ? String[].class : String.class;
        }
        return Object.class;
    }

    private <T extends Map<String, Object>> Object adaptValueForMapOptions(Method attribute, Object value, Class<?> mapType, Function<MergedAnnotation<?>, T> factory, MergedAnnotation.Adapt[] adaptations) {
        if (value instanceof MergedAnnotation) {
            MergedAnnotation annotation = (MergedAnnotation)value;
            return MergedAnnotation.Adapt.ANNOTATION_TO_MAP.containsIn(adaptations) ? annotation.asMap(factory, adaptations) : annotation.synthesize();
        }
        if (value instanceof MergedAnnotation[]) {
            MergedAnnotation[] annotations = (MergedAnnotation[])value;
            if (MergedAnnotation.Adapt.ANNOTATION_TO_MAP.containsIn(adaptations)) {
                Object result = Array.newInstance(mapType, annotations.length);
                for (int i = 0; i < annotations.length; ++i) {
                    Array.set(result, i, annotations[i].asMap(factory, adaptations));
                }
                return result;
            }
            Object result = Array.newInstance(attribute.getReturnType().getComponentType(), annotations.length);
            for (int i = 0; i < annotations.length; ++i) {
                Array.set(result, i, annotations[i].synthesize());
            }
            return result;
        }
        return value;
    }

    @Override
    public boolean isSynthesizable() {
        if (this.getDistance() > 0 && this.resolvedMirrors.length > 0) {
            return true;
        }
        return this.mapping.synthesizable;
    }

    @Override
    protected A createSynthesizedAnnotation() {
        Object rootAttributes;
        Class<A> type = this.getType();
        if (type.isInstance(rootAttributes = this.rootAttributes) && this.isNotSynthesizable((Annotation)rootAttributes)) {
            return (A)((Annotation)rootAttributes);
        }
        Annotation annotation = this.mapping.annotation;
        if (type.isInstance(annotation) && this.isNotSynthesizable(annotation)) {
            return (A)annotation;
        }
        return SynthesizedMergedAnnotationInvocationHandler.createProxy(this, type);
    }

    private boolean isNotSynthesizable(Annotation annotation) {
        if (AnnotationUtils.isSynthesizedAnnotation(annotation)) {
            return true;
        }
        return !this.isSynthesizable();
    }

    @Override
    @Nullable
    protected <T> T getAttributeValue(String attributeName, Class<T> type) {
        int attributeIndex = this.getAttributeIndex(attributeName, false);
        return attributeIndex != -1 ? (T)this.getValue(attributeIndex, type) : null;
    }

    private Object getRequiredValue(int attributeIndex, String attributeName) {
        Object value = this.getValue(attributeIndex, Object.class);
        if (value == null) {
            throw new NoSuchElementException("No element at attribute index " + attributeIndex + " for name " + attributeName);
        }
        return value;
    }

    @Nullable
    private <T> T getValue(int attributeIndex, Class<T> type) {
        Method attribute = this.mapping.methods.get(attributeIndex);
        Object value = this.getValue(attributeIndex, true, false);
        if (value == null) {
            value = attribute.getDefaultValue();
        }
        return this.adapt(attribute, value, type);
    }

    @Nullable
    private Object getValue(int attributeIndex, boolean useConventionMapping, boolean forMirrorResolution) {
        AnnotationTypeMapping mapping = this.mapping;
        if (this.useMergedValues) {
            int mappedIndex = mapping.getAliasMapping(attributeIndex);
            if (mappedIndex == -1 && useConventionMapping) {
                mappedIndex = mapping.getConventionMapping(attributeIndex);
            }
            if (mappedIndex != -1) {
                mapping = mapping.root;
                attributeIndex = mappedIndex;
            }
        }
        if (!forMirrorResolution) {
            attributeIndex = (mapping.distance != 0 ? this.resolvedMirrors : this.resolvedRootMirrors)[attributeIndex];
        }
        if (attributeIndex == -1) {
            return null;
        }
        if (mapping.distance == 0) {
            Method attribute = mapping.methods.get(attributeIndex);
            Object result = this.valueExtractor.extract(attribute, this.rootAttributes);
            return result != null ? result : attribute.getDefaultValue();
        }
        return this.getValueFromMetaAnnotation(attributeIndex, forMirrorResolution);
    }

    @Nullable
    private Object getValueFromMetaAnnotation(int attributeIndex, boolean forMirrorResolution) {
        Object value = null;
        if (this.useMergedValues || forMirrorResolution) {
            value = this.mapping.getMappedAnnotationValue(attributeIndex, forMirrorResolution);
        }
        if (value == null) {
            Method attribute = this.mapping.methods.get(attributeIndex);
            value = ReflectionUtils.invokeMethod(attribute, this.mapping.annotation);
        }
        return value;
    }

    @Nullable
    private Object getValueForMirrorResolution(Method attribute, Object annotation) {
        int attributeIndex = this.mapping.methods.indexOf(attribute);
        boolean valueAttribute = "value".equals(attribute.getName());
        return this.getValue(attributeIndex, !valueAttribute, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    private <T> T adapt(Method attribute, @Nullable Object value, Class<T> type) {
        block13: {
            block16: {
                block15: {
                    block14: {
                        block12: {
                            if (value /* !! */  == null) {
                                return null;
                            }
                            value /* !! */  = this.adaptForAttribute(attribute, value /* !! */ );
                            type = this.getAdaptType(attribute, type);
                            if (!(value /* !! */  instanceof Class) || type != String.class) break block12;
                            value /* !! */  = ((Class)value /* !! */ ).getName();
                            break block13;
                        }
                        if (!(value /* !! */  instanceof String) || type != Class.class) break block14;
                        value /* !! */  = ClassUtils.resolveClassName((String)value /* !! */ , this.getClassLoader());
                        break block13;
                    }
                    if (!(value /* !! */  instanceof Class[]) || type != String[].class) break block15;
                    classes = (Class[])value /* !! */ ;
                    names = new String[classes.length];
                    for (i = 0; i < classes.length; ++i) {
                        names[i] = classes[i].getName();
                    }
                    value /* !! */  = names;
                    break block13;
                }
                if (!(value /* !! */  instanceof String[])) break block16;
                names = (String[])value /* !! */ ;
                if (type != Class[].class) break block16;
                classes = new Class[names.length];
                for (i = 0; i < names.length; ++i) {
                    classes[i] = ClassUtils.resolveClassName(names[i], this.getClassLoader());
                }
                value /* !! */  = classes;
                break block13;
            }
            if (!(value /* !! */  instanceof MergedAnnotation)) ** GOTO lbl-1000
            annotation = (MergedAnnotation)value /* !! */ ;
            if (type.isAnnotation()) {
                value /* !! */  = annotation.synthesize();
            } else if (value /* !! */  instanceof MergedAnnotation[]) {
                annotations = (MergedAnnotation[])value /* !! */ ;
                if (type.isArray() && type.getComponentType().isAnnotation()) {
                    array = Array.newInstance(type.getComponentType(), annotations.length);
                    for (i = 0; i < annotations.length; ++i) {
                        Array.set(array, i, annotations[i].synthesize());
                    }
                    value /* !! */  = array;
                }
            }
        }
        if (ObjectUtils.isArray(value /* !! */ ) && !type.isArray() && type == value /* !! */ .getClass().getComponentType()) {
            length = Array.getLength(value /* !! */ );
            if (length == 1) {
                value /* !! */  = Array.get(value /* !! */ , 0);
            } else {
                throw new IllegalArgumentException("Unable to adapt value of type " + value /* !! */ .getClass().getName() + " to " + type.getName() + " cause incorrect array length: " + length);
            }
        }
        if (!ClassUtils.isAssignableValue(type, value /* !! */ )) {
            throw new IllegalArgumentException("Unable to adapt value of type " + value /* !! */ .getClass().getName() + " to " + type.getName());
        }
        return (T)value /* !! */ ;
    }

    private Object adaptForAttribute(Method attribute, Object value) {
        Class<?> attributeType = ClassUtils.resolvePrimitiveIfNecessary(attribute.getReturnType());
        if (attributeType.isArray() && !value.getClass().isArray()) {
            Object array = Array.newInstance(value.getClass(), 1);
            Array.set(array, 0, value);
            return this.adaptForAttribute(attribute, array);
        }
        if (attributeType.isAnnotation()) {
            return this.adaptToMergedAnnotation(value, attributeType);
        }
        if (attributeType.isArray() && attributeType.getComponentType().isAnnotation()) {
            MergedAnnotation[] result = new MergedAnnotation[Array.getLength(value)];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.adaptToMergedAnnotation(Array.get(value, i), attributeType.getComponentType());
            }
            return result;
        }
        if (attributeType == Class.class && value instanceof String || attributeType == Class[].class && value instanceof String[] || attributeType == String.class && value instanceof Class || attributeType == String[].class && value instanceof Class[]) {
            return value;
        }
        if (attributeType.isArray() && this.isEmptyObjectArray(value)) {
            return this.emptyArray(attributeType.getComponentType());
        }
        if (!attributeType.isInstance(value)) {
            throw new IllegalStateException("Attribute '" + attribute.getName() + "' in annotation " + this.getType().getName() + " should be compatible with " + attributeType.getName() + " but a " + value.getClass().getName() + " value was returned");
        }
        return value;
    }

    private boolean isEmptyObjectArray(Object value) {
        return value instanceof Object[] && ((Object[])value).length == 0;
    }

    private Object emptyArray(Class<?> componentType) {
        Object result = EMPTY_ARRAYS.get(componentType);
        if (result == null) {
            result = Array.newInstance(componentType, 0);
        }
        return result;
    }

    private MergedAnnotation<?> adaptToMergedAnnotation(Object value, Class<? extends Annotation> annotationType) {
        if (value instanceof MergedAnnotation) {
            return (MergedAnnotation)value;
        }
        AnnotationTypeMapping mapping = AnnotationTypeMappings.forAnnotationType(annotationType).get(0);
        return new TypeMappedAnnotation<A>(mapping, null, this.source, value, this.getValueExtractor(value), this.aggregateIndex);
    }

    private ValueExtractor getValueExtractor(Object value) {
        if (value instanceof Annotation) {
            return ReflectionUtils::invokeMethod;
        }
        if (value instanceof Map) {
            return TypeMappedAnnotation::extractFromMap;
        }
        return this.valueExtractor;
    }

    private <T> Class<T> getAdaptType(Method attribute, Class<T> type) {
        if (type != Object.class) {
            return type;
        }
        Class<?> attributeType = attribute.getReturnType();
        if (attributeType.isAnnotation()) {
            return MergedAnnotation.class;
        }
        if (attributeType.isArray() && attributeType.getComponentType().isAnnotation()) {
            return MergedAnnotation[].class;
        }
        return ClassUtils.resolvePrimitiveIfNecessary(attributeType);
    }

    private int getAttributeIndex(String attributeName, boolean required) {
        int attributeIndex;
        Assert.hasText(attributeName, "Attribute name must not be null");
        int n = attributeIndex = this.isFiltered(attributeName) ? -1 : this.mapping.methods.indexOf(attributeName);
        if (attributeIndex == -1 && required) {
            throw new NoSuchElementException("No attribute named '" + attributeName + "' present in merged annotation " + this.getType().getName());
        }
        return attributeIndex;
    }

    private boolean isFiltered(String attributeName) {
        if (this.attributeFilter != null) {
            return !this.attributeFilter.test(attributeName);
        }
        return false;
    }

    @Nullable
    private ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.source != null) {
            if (this.source instanceof Class) {
                return ((Class)this.source).getClassLoader();
            }
            if (this.source instanceof Member) {
                ((Member)this.source).getDeclaringClass().getClassLoader();
            }
        }
        return null;
    }

    static <A extends Annotation> TypeMappedAnnotation<A> from(@Nullable Object source, A annotation) {
        Assert.notNull(annotation, "Annotation must not be null");
        AnnotationTypeMappings mappings = AnnotationTypeMappings.forAnnotationType(annotation.annotationType());
        return new TypeMappedAnnotation<A>(mappings.get(0), null, source, annotation, ReflectionUtils::invokeMethod, 0);
    }

    static <A extends Annotation> MergedAnnotation<A> of(@Nullable ClassLoader classLoader, @Nullable Object source, Class<A> annotationType, @Nullable Map<String, ?> attributes) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        AnnotationTypeMappings mappings = AnnotationTypeMappings.forAnnotationType(annotationType);
        return new TypeMappedAnnotation<A>(mappings.get(0), classLoader, source, attributes, TypeMappedAnnotation::extractFromMap, 0);
    }

    @Nullable
    static <A extends Annotation> TypeMappedAnnotation<A> createIfPossible(AnnotationTypeMapping mapping, MergedAnnotation<?> annotation, IntrospectionFailureLogger logger) {
        if (annotation instanceof TypeMappedAnnotation) {
            TypeMappedAnnotation typeMapped = (TypeMappedAnnotation)annotation;
            return TypeMappedAnnotation.createIfPossible(mapping, typeMapped.source, typeMapped.rootAttributes, typeMapped.valueExtractor, typeMapped.aggregateIndex, logger);
        }
        return TypeMappedAnnotation.createIfPossible(mapping, annotation.getSource(), annotation.synthesize(), annotation.getAggregateIndex(), logger);
    }

    @Nullable
    static <A extends Annotation> TypeMappedAnnotation<A> createIfPossible(AnnotationTypeMapping mapping, @Nullable Object source, Annotation annotation, int aggregateIndex, IntrospectionFailureLogger logger) {
        return TypeMappedAnnotation.createIfPossible(mapping, source, annotation, ReflectionUtils::invokeMethod, aggregateIndex, logger);
    }

    @Nullable
    private static <A extends Annotation> TypeMappedAnnotation<A> createIfPossible(AnnotationTypeMapping mapping, @Nullable Object source, @Nullable Object rootAttribute, ValueExtractor valueExtractor, int aggregateIndex, IntrospectionFailureLogger logger) {
        try {
            return new TypeMappedAnnotation<A>(mapping, null, source, rootAttribute, valueExtractor, aggregateIndex);
        }
        catch (Exception ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            if (logger.isEnabled()) {
                String type = mapping.annotationType.getName();
                String item = mapping.distance == 0 ? "annotation " + type : "meta-annotation " + type + " from " + mapping.root.annotationType.getName();
                logger.log("Failed to introspect " + item, source, ex);
            }
            return null;
        }
    }

    @Nullable
    static Object extractFromMap(Method attribute, @Nullable Object map) {
        return map != null ? ((Map)map).get(attribute.getName()) : null;
    }
}

