/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.annotation;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import cn.taketoday.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;

final class AttributeMethods {
    static final AttributeMethods NONE = new AttributeMethods(null, Constant.EMPTY_METHODS);
    private static final ConcurrentReferenceHashMap<Class<? extends Annotation>, AttributeMethods> cache = new ConcurrentReferenceHashMap();
    private static final Comparator<Method> methodComparator = (m1, m2) -> {
        if (m1 != null && m2 != null) {
            return m1.getName().compareTo(m2.getName());
        }
        return m1 != null ? -1 : 1;
    };
    @Nullable
    private final Class<? extends Annotation> annotationType;
    public final Method[] attributes;
    private final boolean[] canThrowTypeNotPresentException;
    public final boolean hasDefaultValueMethod;
    public final boolean hasNestedAnnotation;

    private AttributeMethods(@Nullable Class<? extends Annotation> annotationType, Method[] attributes) {
        this.annotationType = annotationType;
        this.attributes = attributes;
        this.canThrowTypeNotPresentException = new boolean[attributes.length];
        boolean foundDefaultValueMethod = false;
        boolean foundNestedAnnotation = false;
        for (int i = 0; i < attributes.length; ++i) {
            Method method = attributes[i];
            Class<?> type = method.getReturnType();
            if (!foundDefaultValueMethod && method.getDefaultValue() != null) {
                foundDefaultValueMethod = true;
            }
            if (!foundNestedAnnotation && (type.isAnnotation() || type.isArray() && type.getComponentType().isAnnotation())) {
                foundNestedAnnotation = true;
            }
            ReflectionUtils.makeAccessible(method);
            this.canThrowTypeNotPresentException[i] = type == Class.class || type == Class[].class || type.isEnum();
        }
        this.hasDefaultValueMethod = foundDefaultValueMethod;
        this.hasNestedAnnotation = foundNestedAnnotation;
    }

    boolean hasOnlyValueAttribute() {
        return this.attributes.length == 1 && "value".equals(this.attributes[0].getName());
    }

    boolean isValid(Annotation annotation) {
        this.assertAnnotation(annotation);
        Method[] attributes = this.attributes;
        for (int i = 0; i < attributes.length; ++i) {
            if (!this.canThrowTypeNotPresentException(i)) continue;
            try {
                attributes[i].invoke((Object)annotation, new Object[0]);
                continue;
            }
            catch (Throwable ex) {
                return false;
            }
        }
        return true;
    }

    void validate(Annotation annotation) {
        this.assertAnnotation(annotation);
        Method[] attributes = this.attributes;
        for (int i = 0; i < attributes.length; ++i) {
            if (!this.canThrowTypeNotPresentException(i)) continue;
            try {
                attributes[i].invoke((Object)annotation, new Object[0]);
                continue;
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Could not obtain annotation attribute value for " + attributes[i].getName() + " declared on " + annotation.annotationType(), ex);
            }
        }
    }

    private void assertAnnotation(Annotation annotation) {
        Assert.notNull((Object)annotation, "Annotation must not be null");
        if (this.annotationType != null) {
            Assert.isInstanceOf(this.annotationType, annotation);
        }
    }

    @Nullable
    Method get(String name) {
        int index = this.indexOf(name);
        return index != -1 ? this.attributes[index] : null;
    }

    Method get(int index) {
        return this.attributes[index];
    }

    boolean canThrowTypeNotPresentException(int index) {
        return this.canThrowTypeNotPresentException[index];
    }

    int indexOf(String name) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!this.attributes[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    int indexOf(Method attribute) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!this.attributes[i].equals(attribute)) continue;
            return i;
        }
        return -1;
    }

    int size() {
        return this.attributes.length;
    }

    static AttributeMethods forAnnotationType(@Nullable Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            return NONE;
        }
        return cache.computeIfAbsent(annotationType, AttributeMethods::compute);
    }

    private static AttributeMethods compute(Class<? extends Annotation> annotationType) {
        Method[] methods = annotationType.getDeclaredMethods();
        int size = methods.length;
        for (int i = 0; i < methods.length; ++i) {
            if (AttributeMethods.isAttributeMethod(methods[i])) continue;
            methods[i] = null;
            --size;
        }
        if (size == 0) {
            return NONE;
        }
        Arrays.sort(methods, methodComparator);
        Method[] attributeMethods = Arrays.copyOf(methods, size);
        return new AttributeMethods(annotationType, attributeMethods);
    }

    private static boolean isAttributeMethod(Method method) {
        return method.getParameterCount() == 0 && method.getReturnType() != Void.TYPE;
    }

    static String describe(@Nullable Method attribute) {
        if (attribute == null) {
            return "(none)";
        }
        return AttributeMethods.describe(attribute.getDeclaringClass(), attribute.getName());
    }

    static String describe(@Nullable Class<?> annotationType, @Nullable String attributeName) {
        if (attributeName == null) {
            return "(none)";
        }
        String in = annotationType != null ? " in annotation [" + annotationType.getName() + "]" : "";
        return "attribute '" + attributeName + "'" + in;
    }
}

