/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.annotation;

import cn.taketoday.core.annotation.AnnotationFilter;
import cn.taketoday.core.annotation.AnnotationTypeMapping;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.core.annotation.AnnotationsScanner;
import cn.taketoday.core.annotation.IntrospectionFailureLogger;
import cn.taketoday.core.annotation.RepeatableContainers;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

final class AnnotationTypeMappings {
    private static final IntrospectionFailureLogger failureLogger = IntrospectionFailureLogger.DEBUG;
    private static final ConcurrentReferenceHashMap<AnnotationFilter, Cache> standardRepeatablesCache = new ConcurrentReferenceHashMap();
    private static final ConcurrentReferenceHashMap<AnnotationFilter, Cache> noRepeatablesCache = new ConcurrentReferenceHashMap();
    private final AnnotationFilter filter;
    private final ArrayList<AnnotationTypeMapping> mappings;
    private final RepeatableContainers repeatableContainers;

    private AnnotationTypeMappings(RepeatableContainers repeatableContainers, AnnotationFilter filter, Class<? extends Annotation> annotationType, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        this.filter = filter;
        this.mappings = new ArrayList();
        this.repeatableContainers = repeatableContainers;
        this.addAllMappings(annotationType, visitedAnnotationTypes);
        this.mappings.forEach(AnnotationTypeMapping::afterAllMappingsSet);
    }

    private void addAllMappings(Class<? extends Annotation> annotationType, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        ArrayDeque<AnnotationTypeMapping> queue = new ArrayDeque<AnnotationTypeMapping>();
        this.addIfPossible(queue, null, annotationType, null, visitedAnnotationTypes);
        while (!queue.isEmpty()) {
            AnnotationTypeMapping mapping = queue.removeFirst();
            this.mappings.add(mapping);
            this.addMetaAnnotationsToQueue(queue, mapping);
        }
    }

    private void addMetaAnnotationsToQueue(Deque<AnnotationTypeMapping> queue, AnnotationTypeMapping source) {
        Annotation[] metaAnnotations;
        for (Annotation metaAnnotation : metaAnnotations = AnnotationsScanner.getDeclaredAnnotations(source.annotationType, false)) {
            if (this.isNotMappable(source, metaAnnotation)) continue;
            Annotation[] repeatedAnnotations = this.repeatableContainers.findRepeatedAnnotations(metaAnnotation);
            if (repeatedAnnotations != null) {
                for (Annotation repeatedAnnotation : repeatedAnnotations) {
                    if (this.isNotMappable(source, repeatedAnnotation)) continue;
                    this.addIfPossible(queue, source, repeatedAnnotation);
                }
                continue;
            }
            this.addIfPossible(queue, source, metaAnnotation);
        }
    }

    private void addIfPossible(Deque<AnnotationTypeMapping> queue, AnnotationTypeMapping source, Annotation ann) {
        this.addIfPossible(queue, source, ann.annotationType(), ann, new HashSet<Class<? extends Annotation>>());
    }

    private void addIfPossible(Deque<AnnotationTypeMapping> queue, @Nullable AnnotationTypeMapping source, Class<? extends Annotation> annotationType, @Nullable Annotation ann, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        block2: {
            try {
                queue.addLast(new AnnotationTypeMapping(source, annotationType, ann, visitedAnnotationTypes));
            }
            catch (Exception ex) {
                AnnotationUtils.rethrowAnnotationConfigurationException(ex);
                if (!failureLogger.isEnabled()) break block2;
                failureLogger.log("Failed to introspect meta-annotation " + annotationType.getName(), source != null ? source.annotationType : null, ex);
            }
        }
    }

    private boolean isNotMappable(AnnotationTypeMapping source, @Nullable Annotation metaAnnotation) {
        return metaAnnotation == null || this.filter.matches(metaAnnotation) || AnnotationFilter.PLAIN.matches(source.annotationType) || this.isAlreadyMapped(source, metaAnnotation);
    }

    private boolean isAlreadyMapped(AnnotationTypeMapping source, Annotation metaAnnotation) {
        Class<? extends Annotation> annotationType = metaAnnotation.annotationType();
        AnnotationTypeMapping mapping = source;
        while (mapping != null) {
            if (mapping.annotationType == annotationType) {
                return true;
            }
            mapping = mapping.source;
        }
        return false;
    }

    int size() {
        return this.mappings.size();
    }

    AnnotationTypeMapping get(int index) {
        return this.mappings.get(index);
    }

    static AnnotationTypeMappings forAnnotationType(Class<? extends Annotation> annotationType) {
        return AnnotationTypeMappings.forAnnotationType(annotationType, new HashSet<Class<? extends Annotation>>());
    }

    static AnnotationTypeMappings forAnnotationType(Class<? extends Annotation> annotationType, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        return AnnotationTypeMappings.forAnnotationType(annotationType, RepeatableContainers.standard(), AnnotationFilter.PLAIN, visitedAnnotationTypes);
    }

    static AnnotationTypeMappings forAnnotationType(Class<? extends Annotation> annotationType, RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter) {
        return AnnotationTypeMappings.forAnnotationType(annotationType, repeatableContainers, annotationFilter, new HashSet<Class<? extends Annotation>>());
    }

    private static AnnotationTypeMappings forAnnotationType(Class<? extends Annotation> annotationType, RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        if (repeatableContainers == RepeatableContainers.standard()) {
            return standardRepeatablesCache.computeIfAbsent(annotationFilter, key -> new Cache(repeatableContainers, (AnnotationFilter)key)).get(annotationType, visitedAnnotationTypes);
        }
        if (repeatableContainers == RepeatableContainers.none()) {
            return noRepeatablesCache.computeIfAbsent(annotationFilter, key -> new Cache(repeatableContainers, (AnnotationFilter)key)).get(annotationType, visitedAnnotationTypes);
        }
        return new AnnotationTypeMappings(repeatableContainers, annotationFilter, annotationType, visitedAnnotationTypes);
    }

    static void clearCache() {
        standardRepeatablesCache.clear();
        noRepeatablesCache.clear();
    }

    private static class Cache {
        private final AnnotationFilter filter;
        private final RepeatableContainers repeatableContainers;
        private final ConcurrentReferenceHashMap<Class<? extends Annotation>, AnnotationTypeMappings> mappings;

        Cache(RepeatableContainers repeatableContainers, AnnotationFilter filter) {
            this.repeatableContainers = repeatableContainers;
            this.filter = filter;
            this.mappings = new ConcurrentReferenceHashMap();
        }

        AnnotationTypeMappings get(Class<? extends Annotation> annotationType, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
            return this.mappings.computeIfAbsent(annotationType, key -> this.createMappings((Class<? extends Annotation>)key, visitedAnnotationTypes));
        }

        private AnnotationTypeMappings createMappings(Class<? extends Annotation> annotationType, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
            return new AnnotationTypeMappings(this.repeatableContainers, this.filter, annotationType, visitedAnnotationTypes);
        }
    }
}

