/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.annotation;

import cn.taketoday.core.GenericTypeResolver;
import cn.taketoday.core.annotation.AnnotationAttributes;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.NonNull;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

public interface AnnotationProvider<A extends Annotation> {
    default public A getAnnotation() {
        return this.getAnnotation(this.getClass());
    }

    default public A getAnnotation(AnnotatedElement annotated) {
        Assert.notNull((Object)annotated, "annotated must not be null");
        return AnnotationUtils.getAnnotation(annotated, this.annotationType());
    }

    default public MergedAnnotation<A> getMergedAnnotation(AnnotatedTypeMetadata metadata) {
        Assert.notNull((Object)metadata, "AnnotatedTypeMetadata is required");
        return metadata.getAnnotation(this.annotationType());
    }

    default public A getAnnotation(AnnotatedTypeMetadata metadata) {
        return this.getMergedAnnotation(metadata).synthesize();
    }

    default public AnnotationAttributes getAttributes(AnnotatedTypeMetadata metadata) {
        return AnnotationAttributes.fromMetadata(metadata, this.annotationType());
    }

    @NonNull
    default public Class<A> annotationType() {
        Class generic = GenericTypeResolver.resolveTypeArgument(this.getClass(), AnnotationProvider.class);
        if (generic != null) {
            return generic;
        }
        throw new IllegalArgumentException("Cannot get annotation type on: " + this);
    }
}

