/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.io.Resource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;

public class YamlProcessor {
    private static final Logger log = LoggerFactory.getLogger(YamlProcessor.class);
    private boolean matchDefault = true;
    private Resource[] resources = Resource.EMPTY_ARRAY;
    private ResolutionMethod resolutionMethod = ResolutionMethod.OVERRIDE;
    private List<DocumentMatcher> documentMatchers = Collections.emptyList();
    private Set<String> supportedTypes = Collections.emptySet();

    public void setDocumentMatchers(DocumentMatcher ... matchers) {
        this.documentMatchers = Arrays.asList(matchers);
    }

    public void setMatchDefault(boolean matchDefault) {
        this.matchDefault = matchDefault;
    }

    public void setResolutionMethod(ResolutionMethod resolutionMethod) {
        Assert.notNull((Object)resolutionMethod, "ResolutionMethod must not be null");
        this.resolutionMethod = resolutionMethod;
    }

    public void setResources(Resource ... resources) {
        this.resources = resources;
    }

    public void setSupportedTypes(Class<?> ... supportedTypes) {
        if (ObjectUtils.isEmpty(supportedTypes)) {
            this.supportedTypes = Collections.emptySet();
        } else {
            Assert.noNullElements((Object[])supportedTypes, "'supportedTypes' must not contain null elements");
            this.supportedTypes = Arrays.stream(supportedTypes).map(Class::getName).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        }
    }

    protected void process(MatchCallback callback) {
        Yaml yaml = this.createYaml();
        for (Resource resource : this.resources) {
            boolean found = this.process(callback, yaml, resource);
            if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND || !found) continue;
            return;
        }
    }

    protected Yaml createYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        return new Yaml((BaseConstructor)new FilteringConstructor(loaderOptions), new Representer(), new DumperOptions(), loaderOptions);
    }

    private boolean process(MatchCallback callback, Yaml yaml, Resource resource) {
        int count = 0;
        try {
            log.debug("Loading from YAML: {}", (Object)resource);
            try (UnicodeReader reader = new UnicodeReader(resource.getInputStream());){
                for (Object object : yaml.loadAll((Reader)reader)) {
                    if (object == null || !this.process(this.asMap(object), callback)) continue;
                    ++count;
                    if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND) continue;
                    break;
                }
                log.debug("Loaded {} document {} from YAML resource: {}", count, count > 1 ? "s" : "", resource);
            }
        }
        catch (IOException ex) {
            this.handleProcessError(resource, ex);
        }
        return count > 0;
    }

    private void handleProcessError(Resource resource, IOException ex) {
        if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND && this.resolutionMethod != ResolutionMethod.OVERRIDE_AND_IGNORE) {
            throw new IllegalStateException(ex);
        }
        log.warn("Could not load map from {}: {}", resource, ex.getMessage(), ex);
    }

    private Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put("document", object);
            return result;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = this.asMap(value);
            }
            if (key instanceof CharSequence) {
                result.put(key.toString(), value);
                continue;
            }
            result.put("[" + key.toString() + "]", value);
        }
        return result;
    }

    private boolean process(Map<String, Object> map, MatchCallback callback) {
        Properties properties = CollectionUtils.createStringAdaptingProperties();
        properties.putAll(this.getFlattenedMap(map));
        if (this.documentMatchers.isEmpty()) {
            log.debug("Merging document (no matchers set): {}", (Object)map);
            callback.process(properties, map);
            return true;
        }
        MatchStatus result = MatchStatus.ABSTAIN;
        for (DocumentMatcher matcher : this.documentMatchers) {
            MatchStatus match = matcher.matches(properties);
            result = MatchStatus.getMostSpecific(match, result);
            if (match != MatchStatus.FOUND) continue;
            log.debug("Matched document with document matcher: {}", (Object)properties);
            callback.process(properties, map);
            return true;
        }
        if (result == MatchStatus.ABSTAIN && this.matchDefault) {
            log.debug("Matched document with default matcher: {}", (Object)map);
            callback.process(properties, map);
            return true;
        }
        log.debug("Unmatched document: {}", (Object)map);
        return false;
    }

    protected final Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.buildFlattenedMap(result, source, null);
        return result;
    }

    private void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, @Nullable String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (StringUtils.hasText(path)) {
                key = StringUtils.matchesFirst((String)key, '[') ? path + (String)key : path + "." + (String)key;
            }
            if (value instanceof String) {
                result.put((String)key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, (String)key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    result.put((String)key, "");
                    continue;
                }
                int count = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), (String)key);
                }
                continue;
            }
            result.put((String)key, value != null ? value : "");
        }
    }

    protected void merge(Map<String, Object> output, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Object existing = output.get(key);
            if (value instanceof Map && existing instanceof Map) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>((Map)existing);
                this.merge(result, (Map)value);
                output.put(key, result);
                continue;
            }
            output.put(key, value);
        }
    }

    public static enum ResolutionMethod {
        OVERRIDE,
        OVERRIDE_AND_IGNORE,
        FIRST_FOUND;

    }

    @FunctionalInterface
    public static interface MatchCallback {
        public void process(Properties var1, Map<String, Object> var2);
    }

    private class FilteringConstructor
    extends Constructor {
        FilteringConstructor(LoaderOptions loaderOptions) {
            super(loaderOptions);
        }

        protected Class<?> getClassForName(String name) throws ClassNotFoundException {
            Assert.state(YamlProcessor.this.supportedTypes.contains(name), () -> "Unsupported type encountered in YAML document: " + name);
            return super.getClassForName(name);
        }
    }

    public static enum MatchStatus {
        FOUND,
        NOT_FOUND,
        ABSTAIN;


        public static MatchStatus getMostSpecific(MatchStatus a, MatchStatus b) {
            return a.ordinal() < b.ordinal() ? a : b;
        }
    }

    @FunctionalInterface
    public static interface DocumentMatcher {
        public MatchStatus matches(Properties var1);
    }
}

