/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.ResolvableType;
import cn.taketoday.lang.Assert;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeReference<T> {
    private final Type type;

    protected TypeReference() {
        Class<?> typeReferenceSubclass = TypeReference.findTypeReferenceSubclass(this.getClass());
        Type type = typeReferenceSubclass.getGenericSuperclass();
        Assert.isInstanceOf(ParameterizedType.class, (Object)type, "Type must be a parameterized type");
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Assert.isTrue(actualTypeArguments.length == 1, "Number of type arguments must be 1");
        this.type = actualTypeArguments[0];
    }

    private TypeReference(Type type) {
        this.type = type;
    }

    public final ResolvableType getResolvableType() {
        return ResolvableType.fromType(this.getType());
    }

    public final Type getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TypeReference && this.type.equals(((TypeReference)other).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "TypeReference<" + this.type + ">";
    }

    public static <T> TypeReference<T> fromType(Type type) {
        return new TypeReference<T>(type){};
    }

    private static Class<?> findTypeReferenceSubclass(Class<?> child) {
        Class<?> parent = child.getSuperclass();
        if (Object.class == parent) {
            throw new IllegalStateException("Expected TypeReference superclass");
        }
        if (TypeReference.class == parent) {
            return child;
        }
        return TypeReference.findTypeReferenceSubclass(parent);
    }
}

