/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.MethodParameter;
import cn.taketoday.core.ResolvableTypeProvider;
import cn.taketoday.core.SerializableTypeWrapper;
import cn.taketoday.core.TypeReference;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class ResolvableType
implements Serializable {
    public static final ResolvableType NONE = new ResolvableType(EmptyType.INSTANCE, null, null, 0);
    public static final ResolvableType[] EMPTY_TYPES_ARRAY = new ResolvableType[0];
    private static final ConcurrentReferenceHashMap<ResolvableType, ResolvableType> cache = new ConcurrentReferenceHashMap(256);
    private final Type type;
    @Nullable
    private final SerializableTypeWrapper.TypeProvider typeProvider;
    @Nullable
    private final VariableResolver variableResolver;
    @Nullable
    private final ResolvableType componentType;
    @Nullable
    private final Integer hash;
    @Nullable
    private Class<?> resolved;
    @Nullable
    private ResolvableType superType;
    @Nullable
    private ResolvableType[] interfaces;
    @Nullable
    private ResolvableType[] generics;

    private ResolvableType(Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = null;
        this.hash = this.calculateHashCode();
        this.resolved = null;
    }

    private ResolvableType(Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver, @Nullable Integer hash) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = null;
        this.hash = hash;
        this.resolved = this.resolveClass();
    }

    private ResolvableType(Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver, @Nullable ResolvableType componentType) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = componentType;
        this.hash = null;
        this.resolved = this.resolveClass();
    }

    private ResolvableType(@Nullable Class<?> clazz) {
        this.type = this.resolved = clazz != null ? clazz : Object.class;
        this.typeProvider = null;
        this.variableResolver = null;
        this.componentType = null;
        this.hash = null;
    }

    public Type getType() {
        return SerializableTypeWrapper.unwrap(this.type);
    }

    @Nullable
    public Class<?> getRawClass() {
        if (this.type == this.resolved) {
            return this.resolved;
        }
        Type rawType = this.type;
        if (rawType instanceof ParameterizedType) {
            rawType = ((ParameterizedType)rawType).getRawType();
        }
        if (rawType instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    public Object getSource() {
        Object source;
        if (this.typeProvider != null && (source = this.typeProvider.getSource()) != null) {
            return source;
        }
        return this.type;
    }

    public Class<?> toClass() {
        return this.resolve(Object.class);
    }

    public boolean isInstance(@Nullable Object obj) {
        return obj != null && this.isAssignableFrom(obj.getClass());
    }

    public boolean isAssignableFrom(Class<?> other) {
        return this.isAssignableFrom(ResolvableType.fromClass(other), null);
    }

    public boolean isAssignableFrom(ResolvableType other) {
        return this.isAssignableFrom(other, null);
    }

    private boolean isAssignableFrom(ResolvableType other, @Nullable Map<Type, Type> matchedBefore) {
        Assert.notNull((Object)other, "ResolvableType must not be null");
        if (this == NONE || other == NONE) {
            return false;
        }
        if (this.isArray()) {
            return other.isArray() && this.getComponentType().isAssignableFrom(other.getComponentType());
        }
        if (matchedBefore != null && matchedBefore.get(this.type) == other.type) {
            return true;
        }
        WildcardBounds ourBounds = WildcardBounds.get(this);
        WildcardBounds typeBounds = WildcardBounds.get(other);
        if (typeBounds != null) {
            return ourBounds != null && ourBounds.isSameKind(typeBounds) && ourBounds.isAssignableFrom(typeBounds.getBounds());
        }
        if (ourBounds != null) {
            return ourBounds.isAssignableFrom(other);
        }
        boolean exactMatch = matchedBefore != null;
        boolean checkGenerics = true;
        Class<?> ourResolved = null;
        Type type = this.type;
        if (type instanceof TypeVariable) {
            ResolvableType resolved;
            TypeVariable variable = (TypeVariable)type;
            if (this.variableResolver != null && (resolved = this.variableResolver.resolveVariable(variable)) != null) {
                ourResolved = resolved.resolve();
            }
            if (ourResolved == null && other.variableResolver != null && (resolved = other.variableResolver.resolveVariable(variable)) != null) {
                ourResolved = resolved.resolve();
                checkGenerics = false;
            }
            if (ourResolved == null) {
                exactMatch = false;
            }
        }
        if (ourResolved == null) {
            ourResolved = this.resolve(Object.class);
        }
        Class<?> otherResolved = other.toClass();
        if (exactMatch ? !ourResolved.equals(otherResolved) : !ClassUtils.isAssignable(ourResolved, otherResolved)) {
            return false;
        }
        if (checkGenerics) {
            ResolvableType[] typeGenerics;
            ResolvableType[] ourGenerics = this.getGenerics();
            if (ourGenerics.length != (typeGenerics = other.as(ourResolved).getGenerics()).length) {
                return false;
            }
            if (matchedBefore == null) {
                matchedBefore = new IdentityHashMap<Type, Type>(1);
            }
            matchedBefore.put(this.type, other.type);
            for (int i = 0; i < ourGenerics.length; ++i) {
                if (ourGenerics[i].isAssignableFrom(typeGenerics[i], matchedBefore)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isArray() {
        if (this == NONE) {
            return false;
        }
        Type type = this.type;
        return type instanceof Class && ((Class)type).isArray() || type instanceof GenericArrayType || this.resolveType(type).isArray();
    }

    public ResolvableType getComponentType() {
        if (this == NONE) {
            return NONE;
        }
        if (this.componentType != null) {
            return this.componentType;
        }
        Type type = this.type;
        if (type instanceof Class) {
            Class<?> componentType = ((Class)type).getComponentType();
            return ResolvableType.valueOf(componentType, this.variableResolver);
        }
        if (type instanceof GenericArrayType) {
            return ResolvableType.valueOf(((GenericArrayType)type).getGenericComponentType(), this.variableResolver);
        }
        return this.resolveType(type).getComponentType();
    }

    public ResolvableType asCollection() {
        return this.as(Collection.class);
    }

    public ResolvableType asMap() {
        return this.as(Map.class);
    }

    public ResolvableType as(Class<?> type) {
        if (this == NONE) {
            return NONE;
        }
        if (this.resolved == null || this.resolved == type) {
            return this;
        }
        for (ResolvableType interfaceType : this.getInterfaces()) {
            ResolvableType interfaceAsType = interfaceType.as(type);
            if (interfaceAsType == NONE) continue;
            return interfaceAsType;
        }
        return this.getSuperType().as(type);
    }

    public ResolvableType getSuperType() {
        Class<?> resolved = this.resolve();
        if (resolved == null) {
            return NONE;
        }
        try {
            Type superclass = resolved.getGenericSuperclass();
            if (superclass == null) {
                return NONE;
            }
            ResolvableType superType = this.superType;
            if (superType == null) {
                this.superType = superType = ResolvableType.fromType(superclass, this);
            }
            return superType;
        }
        catch (TypeNotPresentException ex) {
            return NONE;
        }
    }

    public ResolvableType[] getInterfaces() {
        Class<?> resolved = this.resolve();
        if (resolved == null) {
            return EMPTY_TYPES_ARRAY;
        }
        ResolvableType[] interfaces = this.interfaces;
        if (interfaces == null) {
            Type[] genericIfcs = resolved.getGenericInterfaces();
            interfaces = new ResolvableType[genericIfcs.length];
            for (int i = 0; i < genericIfcs.length; ++i) {
                interfaces[i] = ResolvableType.fromType(genericIfcs[i], this);
            }
            this.interfaces = interfaces;
        }
        return interfaces;
    }

    public boolean hasGenerics() {
        return this.getGenerics().length > 0;
    }

    boolean isEntirelyUnresolvable() {
        ResolvableType[] generics;
        if (this == NONE) {
            return false;
        }
        for (ResolvableType generic : generics = this.getGenerics()) {
            if (generic.isUnresolvableTypeVariable() || generic.isWildcardWithoutBounds()) continue;
            return false;
        }
        return true;
    }

    public boolean hasUnresolvableGenerics() {
        ResolvableType[] generics;
        if (this == NONE) {
            return false;
        }
        for (ResolvableType generic : generics = this.getGenerics()) {
            if (!generic.isUnresolvableTypeVariable() && !generic.isWildcardWithoutBounds()) continue;
            return true;
        }
        Class<?> resolved = this.resolve();
        if (resolved != null) {
            try {
                for (Type genericInterface : resolved.getGenericInterfaces()) {
                    if (!(genericInterface instanceof Class) || !ResolvableType.fromClass((Class)genericInterface).hasGenerics()) continue;
                    return true;
                }
            }
            catch (TypeNotPresentException typeNotPresentException) {
                // empty catch block
            }
            return this.getSuperType().hasUnresolvableGenerics();
        }
        return false;
    }

    private boolean isUnresolvableTypeVariable() {
        Type type = this.type;
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            if (this.variableResolver == null) {
                return true;
            }
            ResolvableType resolved = this.variableResolver.resolveVariable(variable);
            return resolved == null || resolved.isUnresolvableTypeVariable();
        }
        return false;
    }

    private boolean isWildcardWithoutBounds() {
        WildcardType wt;
        Type type = this.type;
        if (type instanceof WildcardType && (wt = (WildcardType)type).getLowerBounds().length == 0) {
            Type[] upperBounds = wt.getUpperBounds();
            return upperBounds.length == 0 || upperBounds.length == 1 && Object.class == upperBounds[0];
        }
        return false;
    }

    public ResolvableType getNested(int nestingLevel) {
        return this.getNested(nestingLevel, null);
    }

    public ResolvableType getNested(int nestingLevel, @Nullable Map<Integer, Integer> typeIndexesPerLevel) {
        ResolvableType result = this;
        for (int i = 2; i <= nestingLevel; ++i) {
            if (result.isArray()) {
                result = result.getComponentType();
                continue;
            }
            while (result != NONE && !result.hasGenerics()) {
                result = result.getSuperType();
            }
            Integer index = null;
            if (typeIndexesPerLevel != null) {
                index = typeIndexesPerLevel.get(i);
            }
            if (index == null) {
                index = result.getGenerics().length - 1;
            }
            result = result.getGeneric(index);
        }
        return result;
    }

    public ResolvableType getGeneric(int ... indexes) {
        ResolvableType[] generics = this.getGenerics();
        if (indexes == null || indexes.length == 0) {
            return generics.length == 0 ? NONE : generics[0];
        }
        ResolvableType generic = this;
        for (int index : indexes) {
            generics = generic.getGenerics();
            if (index < 0 || index >= generics.length) {
                return NONE;
            }
            generic = generics[index];
        }
        return generic;
    }

    public ResolvableType[] getGenerics() {
        if (this == NONE) {
            return EMPTY_TYPES_ARRAY;
        }
        ResolvableType[] generics = this.generics;
        if (generics == null) {
            Type type = this.type;
            if (type instanceof Class) {
                Class type2 = (Class)type;
                typeParams = type2.getTypeParameters();
                generics = new ResolvableType[typeParams.length];
                for (int i = 0; i < generics.length; ++i) {
                    generics[i] = ResolvableType.fromType(typeParams[i], this);
                }
            } else {
                typeParams = this.type;
                if (typeParams instanceof ParameterizedType) {
                    ParameterizedType type3 = (ParameterizedType)typeParams;
                    Type[] actualTypeArguments = type3.getActualTypeArguments();
                    generics = new ResolvableType[actualTypeArguments.length];
                    for (int i = 0; i < actualTypeArguments.length; ++i) {
                        generics[i] = ResolvableType.valueOf(actualTypeArguments[i], this.variableResolver);
                    }
                } else {
                    generics = this.resolveType(this.type).getGenerics();
                }
            }
            this.generics = generics;
        }
        return generics;
    }

    public Class<?>[] resolveGenerics() {
        ResolvableType[] generics = this.getGenerics();
        Class[] resolvedGenerics = new Class[generics.length];
        for (int i = 0; i < generics.length; ++i) {
            resolvedGenerics[i] = generics[i].resolve();
        }
        return resolvedGenerics;
    }

    public Class<?>[] resolveGenerics(Class<?> fallback) {
        ResolvableType[] generics = this.getGenerics();
        Class[] resolvedGenerics = new Class[generics.length];
        for (int i = 0; i < generics.length; ++i) {
            resolvedGenerics[i] = generics[i].resolve(fallback);
        }
        return resolvedGenerics;
    }

    @Nullable
    public Class<?> resolveGeneric(int ... indexes) {
        return this.getGeneric(indexes).resolve();
    }

    @Nullable
    public Class<?> resolve() {
        return this.resolved;
    }

    public boolean is(Class<?> clazz) {
        return this.resolved == clazz;
    }

    public boolean isCollection() {
        return CollectionUtils.isCollection(this.resolved);
    }

    public boolean isMap() {
        return this.resolved != null && Map.class.isAssignableFrom(this.resolved);
    }

    public Class<?> resolve(Class<?> fallback) {
        return this.resolved != null ? this.resolved : fallback;
    }

    @Nullable
    private Class<?> resolveClass() {
        Type type = this.type;
        if (type == EmptyType.INSTANCE) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            Class<?> resolvedComponent = this.getComponentType().resolve();
            return resolvedComponent != null ? Array.newInstance(resolvedComponent, 0).getClass() : null;
        }
        return this.resolveType(type).resolve();
    }

    ResolvableType resolveType() {
        return this.resolveType(this.type);
    }

    private ResolvableType resolveType(Type type) {
        if (type instanceof ParameterizedType) {
            return ResolvableType.valueOf(((ParameterizedType)type).getRawType(), this.variableResolver);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type resolved = this.resolveBounds(wildcardType.getUpperBounds());
            if (resolved == null) {
                resolved = this.resolveBounds(wildcardType.getLowerBounds());
            }
            return ResolvableType.valueOf(resolved, this.variableResolver);
        }
        if (type instanceof TypeVariable) {
            ResolvableType resolved;
            TypeVariable variable = (TypeVariable)type;
            VariableResolver variableResolver = this.variableResolver;
            if (variableResolver != null && (resolved = variableResolver.resolveVariable(variable)) != null) {
                return resolved;
            }
            return ResolvableType.valueOf(this.resolveBounds(variable.getBounds()), variableResolver);
        }
        return NONE;
    }

    @Nullable
    private Type resolveBounds(Type[] bounds) {
        if (bounds.length == 0 || bounds[0] == Object.class) {
            return null;
        }
        return bounds[0];
    }

    @Nullable
    private ResolvableType resolveVariable(TypeVariable<?> variable) {
        ResolvableType resolved;
        Type type = this.type;
        if (type instanceof TypeVariable) {
            return this.resolveType(type).resolveVariable(variable);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class<?> resolved2 = this.resolve();
            if (resolved2 == null) {
                return null;
            }
            TypeVariable<Class<?>>[] variables = resolved2.getTypeParameters();
            for (int i = 0; i < variables.length; ++i) {
                if (!Objects.equals(variables[i].getName(), variable.getName())) continue;
                Type actualType = parameterizedType.getActualTypeArguments()[i];
                return ResolvableType.valueOf(actualType, this.variableResolver);
            }
            Type ownerType = parameterizedType.getOwnerType();
            if (ownerType != null) {
                return ResolvableType.valueOf(ownerType, this.variableResolver).resolveVariable(variable);
            }
        }
        if (type instanceof WildcardType && (resolved = this.resolveType(type).resolveVariable(variable)) != null) {
            return resolved;
        }
        if (this.variableResolver != null) {
            return this.variableResolver.resolveVariable(variable);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolvableType)) {
            return false;
        }
        ResolvableType otherType = (ResolvableType)other;
        if (!Objects.equals(this.type, otherType.type)) {
            return false;
        }
        if (!(this.typeProvider == otherType.typeProvider || this.typeProvider != null && otherType.typeProvider != null && Objects.equals(this.typeProvider.getType(), otherType.typeProvider.getType()))) {
            return false;
        }
        if (!(this.variableResolver == otherType.variableResolver || this.variableResolver != null && otherType.variableResolver != null && ObjectUtils.nullSafeEquals(this.variableResolver.getSource(), otherType.variableResolver.getSource()))) {
            return false;
        }
        return Objects.equals(this.componentType, otherType.componentType);
    }

    public int hashCode() {
        return this.hash != null ? this.hash.intValue() : this.calculateHashCode();
    }

    private int calculateHashCode() {
        int hashCode = Objects.hashCode(this.type);
        if (this.typeProvider != null) {
            hashCode = 31 * hashCode + Objects.hashCode(this.typeProvider.getType());
        }
        if (this.variableResolver != null) {
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.variableResolver.getSource());
        }
        if (this.componentType != null) {
            hashCode = 31 * hashCode + Objects.hashCode(this.componentType);
        }
        return hashCode;
    }

    @Nullable
    VariableResolver asVariableResolver() {
        if (this == NONE) {
            return null;
        }
        return new DefaultVariableResolver(this);
    }

    private Object readResolve() {
        return this.type == EmptyType.INSTANCE ? NONE : this;
    }

    public String toString() {
        if (this.isArray()) {
            return this.getComponentType() + "[]";
        }
        if (this.resolved == null) {
            return "?";
        }
        Type type = this.type;
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            if (this.variableResolver == null || this.variableResolver.resolveVariable(variable) == null) {
                return "?";
            }
        }
        if (this.hasGenerics()) {
            return this.resolved.getName() + "<" + StringUtils.arrayToDelimitedString(this.getGenerics(), ", ") + ">";
        }
        return this.resolved.getName();
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter) {
        return ResolvableType.forMethodParameter(methodParameter, (Type)null);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, @Nullable ResolvableType implementationType) {
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        implementationType = implementationType != null ? implementationType : ResolvableType.fromType(methodParameter.getContainingClass());
        ResolvableType owner = implementationType.as(methodParameter.getDeclaringClass());
        return ResolvableType.valueOf(null, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), owner.asVariableResolver()).getNested(methodParameter.getNestingLevel(), methodParameter.typeIndexesPerLevel);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, @Nullable Type targetType) {
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        return ResolvableType.forMethodParameter(methodParameter, targetType, methodParameter.getNestingLevel());
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, @Nullable Type targetType, int nestingLevel) {
        ResolvableType owner = ResolvableType.fromType(methodParameter.getContainingClass()).as(methodParameter.getDeclaringClass());
        return ResolvableType.valueOf(targetType, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), owner.asVariableResolver()).getNested(nestingLevel, methodParameter.typeIndexesPerLevel);
    }

    public static ResolvableType forParameter(Executable executable, int parameterIndex) {
        return ResolvableType.forParameter(executable, parameterIndex, null);
    }

    public static ResolvableType forReturnType(Method method) {
        Assert.notNull((Object)method, "Method must not be null");
        Type genericReturnType = method.getGenericReturnType();
        return ResolvableType.fromType(genericReturnType);
    }

    public static ResolvableType forReturnType(final Method method, @Nullable Class<?> implementationClass) {
        Assert.notNull((Object)method, "Method must not be null");
        Class<?> declaringClass = method.getDeclaringClass();
        ResolvableType owner = implementationClass == null ? ResolvableType.fromType(declaringClass) : ResolvableType.fromType(implementationClass).as(declaringClass);
        return ResolvableType.valueOf(null, new SerializableTypeWrapper.TypeProvider(){

            @Override
            public Type getType() {
                return method.getGenericReturnType();
            }

            @Override
            public Object getSource() {
                return method;
            }
        }, owner.asVariableResolver());
    }

    public static ResolvableType forParameter(Executable executable, int parameterIndex, @Nullable Class<?> implementationClass) {
        Parameter parameter = ReflectionUtils.getParameter(executable, parameterIndex);
        Class<?> declaringClass = executable.getDeclaringClass();
        ResolvableType owner = implementationClass == null ? ResolvableType.fromType(declaringClass) : ResolvableType.fromType(implementationClass).as(declaringClass);
        return ResolvableType.valueOf(null, new SerializableTypeWrapper.ParameterTypeProvider(parameter, parameterIndex), owner.asVariableResolver());
    }

    public static ResolvableType fromParameter(Parameter parameter) {
        return ResolvableType.fromParameter(parameter, (Type)null);
    }

    public static ResolvableType fromParameter(Parameter parameter, @Nullable ResolvableType implementationType) {
        Assert.notNull((Object)parameter, "Parameter must not be null");
        Executable executable = parameter.getDeclaringExecutable();
        Class<?> declaringClass = executable.getDeclaringClass();
        ResolvableType owner = implementationType != null ? implementationType.as(declaringClass) : ResolvableType.fromType(declaringClass);
        return ResolvableType.valueOf(null, new SerializableTypeWrapper.ParameterTypeProvider(parameter), owner.asVariableResolver());
    }

    public static ResolvableType fromParameter(Parameter parameter, Class<?> implementationType) {
        return ResolvableType.fromParameter(parameter, ResolvableType.fromType(implementationType));
    }

    public static ResolvableType fromParameter(Parameter parameter, @Nullable Type targetType) {
        Assert.notNull((Object)parameter, "Parameter must not be null");
        Executable executable = parameter.getDeclaringExecutable();
        Class<?> declaringClass = executable.getDeclaringClass();
        ResolvableType owner = ResolvableType.fromType(declaringClass);
        return ResolvableType.valueOf(targetType, new SerializableTypeWrapper.ParameterTypeProvider(parameter), owner.asVariableResolver());
    }

    public static ResolvableType fromClass(Class<?> clazz) {
        return new ResolvableType(clazz);
    }

    public static ResolvableType fromRawClass(final @Nullable Class<?> clazz) {
        return new ResolvableType(clazz){

            @Override
            public ResolvableType[] getGenerics() {
                return EMPTY_TYPES_ARRAY;
            }

            @Override
            public boolean isAssignableFrom(Class<?> other) {
                return clazz == null || ClassUtils.isAssignable(clazz, other);
            }

            @Override
            public boolean isAssignableFrom(ResolvableType other) {
                Class<?> otherClass = other.resolve();
                return otherClass != null && (clazz == null || ClassUtils.isAssignable(clazz, otherClass));
            }
        };
    }

    public static ResolvableType fromClass(Class<?> baseType, Class<?> implementationClass) {
        Assert.notNull(baseType, "Base type must not be null");
        ResolvableType asType = ResolvableType.fromType(implementationClass).as(baseType);
        return asType == NONE ? ResolvableType.fromType(baseType) : asType;
    }

    public static ResolvableType fromClassWithGenerics(Class<?> clazz, Class<?> ... generics) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(generics, "Generics array must not be null");
        ResolvableType[] resolvableGenerics = new ResolvableType[generics.length];
        for (int i = 0; i < generics.length; ++i) {
            resolvableGenerics[i] = ResolvableType.fromClass(generics[i]);
        }
        return ResolvableType.fromClassWithGenerics(clazz, resolvableGenerics);
    }

    public static ResolvableType fromClassWithGenerics(Class<?> clazz, ResolvableType ... generics) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)generics, "Generics array must not be null");
        TypeVariable<Class<?>>[] variables = clazz.getTypeParameters();
        Assert.isTrue(variables.length == generics.length, "Mismatched number of generics specified");
        Type[] arguments = new Type[generics.length];
        for (int i = 0; i < generics.length; ++i) {
            ResolvableType generic = generics[i];
            Type argument = generic != null ? generic.getType() : null;
            arguments[i] = argument != null && !(argument instanceof TypeVariable) ? argument : variables[i];
        }
        SyntheticParameterizedType syntheticType = new SyntheticParameterizedType(clazz, arguments);
        return ResolvableType.valueOf(syntheticType, new TypeVariablesVariableResolver(variables, generics));
    }

    public static ResolvableType fromInstance(@Nullable Object instance) {
        ResolvableTypeProvider provider;
        ResolvableType type;
        if (instance == null) {
            return NONE;
        }
        if (instance instanceof ResolvableTypeProvider && (type = (provider = (ResolvableTypeProvider)instance).getResolvableType()) != null) {
            return type;
        }
        return ResolvableType.fromClass(instance.getClass());
    }

    public static ResolvableType fromField(Field field) {
        Assert.notNull((Object)field, "Field is required");
        return ResolvableType.valueOf(null, new SerializableTypeWrapper.FieldTypeProvider(field), null);
    }

    public static ResolvableType fromField(Field field, Class<?> implementationClass) {
        Assert.notNull((Object)field, "Field is required");
        ResolvableType owner = ResolvableType.fromType(implementationClass).as(field.getDeclaringClass());
        return ResolvableType.valueOf(null, new SerializableTypeWrapper.FieldTypeProvider(field), owner.asVariableResolver());
    }

    public static ResolvableType fromField(Field field, @Nullable ResolvableType implementationType) {
        Assert.notNull((Object)field, "Field is required");
        ResolvableType owner = implementationType != null ? implementationType : NONE;
        owner = owner.as(field.getDeclaringClass());
        return ResolvableType.valueOf(null, new SerializableTypeWrapper.FieldTypeProvider(field), owner.asVariableResolver());
    }

    public static ResolvableType fromField(Field field, int nestingLevel) {
        Assert.notNull((Object)field, "Field is required");
        return ResolvableType.valueOf(null, new SerializableTypeWrapper.FieldTypeProvider(field), null).getNested(nestingLevel);
    }

    public static ResolvableType fromField(Field field, int nestingLevel, Class<?> implementationClass) {
        Assert.notNull((Object)field, "Field is required");
        ResolvableType owner = ResolvableType.fromType(implementationClass).as(field.getDeclaringClass());
        return ResolvableType.valueOf(null, new SerializableTypeWrapper.FieldTypeProvider(field), owner.asVariableResolver()).getNested(nestingLevel);
    }

    public static ResolvableType fromArrayComponent(ResolvableType componentType) {
        Assert.notNull((Object)componentType, "Component type must not be null");
        Class<?> arrayClass = Array.newInstance(componentType.resolve(), 0).getClass();
        return new ResolvableType(arrayClass, null, null, componentType);
    }

    public static ResolvableType fromType(@Nullable Type type) {
        return ResolvableType.valueOf(type, null, null);
    }

    public static ResolvableType fromType(@Nullable Type type, @Nullable ResolvableType owner) {
        VariableResolver variableResolver = null;
        if (owner != null) {
            variableResolver = owner.asVariableResolver();
        }
        return ResolvableType.valueOf(type, variableResolver);
    }

    public static ResolvableType fromType(TypeReference<?> typeReference) {
        return ResolvableType.valueOf(typeReference.getType(), null, null);
    }

    public static ResolvableType valueOf(@Nullable Type type, @Nullable VariableResolver variableResolver) {
        return ResolvableType.valueOf(type, null, variableResolver);
    }

    public static ResolvableType valueOf(@Nullable Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver) {
        if (type == null && typeProvider != null) {
            type = SerializableTypeWrapper.fromTypeProvider(typeProvider);
        }
        if (type == null) {
            return NONE;
        }
        if (type instanceof Class) {
            return new ResolvableType(type, typeProvider, variableResolver, (ResolvableType)null);
        }
        cache.purgeUnreferencedEntries();
        ResolvableType resultType = new ResolvableType(type, typeProvider, variableResolver);
        ResolvableType cachedType = cache.get(resultType);
        if (cachedType == null) {
            cachedType = new ResolvableType(type, typeProvider, variableResolver, resultType.hash);
            cache.put(cachedType, cachedType);
        }
        resultType.resolved = cachedType.resolved;
        return resultType;
    }

    public static void clearCache() {
        cache.clear();
        SerializableTypeWrapper.cache.clear();
    }

    public static interface VariableResolver
    extends Serializable {
        public Object getSource();

        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> var1);
    }

    record WildcardBounds(Kind kind, ResolvableType[] bounds) {
        public boolean isSameKind(WildcardBounds bounds) {
            return this.kind == bounds.kind;
        }

        public boolean isAssignableFrom(ResolvableType ... types) {
            for (ResolvableType bound : this.bounds) {
                for (ResolvableType type : types) {
                    if (this.isAssignable(bound, type)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean isAssignable(ResolvableType source, ResolvableType from) {
            return this.kind == Kind.UPPER ? source.isAssignableFrom(from) : from.isAssignableFrom(source);
        }

        public ResolvableType[] getBounds() {
            return this.bounds;
        }

        @Nullable
        public static WildcardBounds get(ResolvableType type) {
            ResolvableType resolveToWildcard = type;
            while (!(resolveToWildcard.getType() instanceof WildcardType)) {
                if (resolveToWildcard == NONE) {
                    return null;
                }
                resolveToWildcard = resolveToWildcard.resolveType();
            }
            WildcardType wildcardType = (WildcardType)resolveToWildcard.type;
            Kind boundsType = wildcardType.getLowerBounds().length > 0 ? Kind.LOWER : Kind.UPPER;
            Type[] bounds = boundsType == Kind.UPPER ? wildcardType.getUpperBounds() : wildcardType.getLowerBounds();
            ResolvableType[] resolvableBounds = new ResolvableType[bounds.length];
            for (int i = 0; i < bounds.length; ++i) {
                resolvableBounds[i] = ResolvableType.valueOf(bounds[i], type.variableResolver);
            }
            return new WildcardBounds(boundsType, resolvableBounds);
        }

        static enum Kind {
            UPPER,
            LOWER;

        }
    }

    static class EmptyType
    implements Type,
    Serializable {
        static final Type INSTANCE = new EmptyType();

        EmptyType() {
        }

        Object readResolve() {
            return INSTANCE;
        }
    }

    static class DefaultVariableResolver
    implements VariableResolver {
        final ResolvableType source;

        DefaultVariableResolver(ResolvableType resolvableType) {
            this.source = resolvableType;
        }

        @Override
        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            return this.source.resolveVariable(variable);
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    record SyntheticParameterizedType(Type rawType, Type[] typeArguments) implements ParameterizedType,
    Serializable
    {
        @Override
        public String getTypeName() {
            String typeName = this.rawType.getTypeName();
            if (this.typeArguments.length > 0) {
                StringJoiner stringJoiner = new StringJoiner(", ", "<", ">");
                for (Type argument : this.typeArguments) {
                    stringJoiner.add(argument.getTypeName());
                }
                return typeName + stringJoiner;
            }
            return typeName;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType otherType = (ParameterizedType)other;
            return otherType.getOwnerType() == null && this.rawType.equals(otherType.getRawType()) && Arrays.equals(this.typeArguments, otherType.getActualTypeArguments());
        }

        @Override
        public int hashCode() {
            return this.rawType.hashCode() * 31 + Arrays.hashCode(this.typeArguments);
        }

        @Override
        public String toString() {
            return this.getTypeName();
        }
    }

    record TypeVariablesVariableResolver(TypeVariable<?>[] variables, ResolvableType[] generics) implements VariableResolver
    {
        @Override
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            TypeVariable<?> variableToCompare = SerializableTypeWrapper.unwrap(variable);
            TypeVariable<?>[] variables = this.variables;
            for (int i = 0; i < variables.length; ++i) {
                TypeVariable<?> resolvedVariable = SerializableTypeWrapper.unwrap(variables[i]);
                if (!Objects.equals(resolvedVariable, variableToCompare)) continue;
                return this.generics[i];
            }
            return null;
        }

        @Override
        public Object getSource() {
            return this.generics;
        }
    }
}

