/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.ReactiveAdapter;
import cn.taketoday.core.ReactiveTypeDescriptor;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.adapter.JdkFlowAdapter;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAdapterRegistry {
    @Nullable
    private static volatile ReactiveAdapterRegistry sharedInstance;
    private static final boolean mutinyPresent;
    private static final boolean reactorPresent;
    private static final boolean rxjava3Present;
    private final ArrayList<ReactiveAdapter> adapters = new ArrayList();

    public ReactiveAdapterRegistry() {
        if (reactorPresent) {
            new ReactorRegistrar().registerAdapters(this);
        }
        if (rxjava3Present) {
            new RxJava3Registrar().registerAdapters(this);
        }
        if (mutinyPresent) {
            new MutinyRegistrar().registerAdapters(this);
        }
    }

    public boolean hasAdapters() {
        return !this.adapters.isEmpty();
    }

    public void registerReactiveType(ReactiveTypeDescriptor descriptor, Function<Object, Publisher<?>> toAdapter, Function<Publisher<?>, Object> fromAdapter) {
        if (reactorPresent) {
            this.adapters.add(new ReactorAdapter(descriptor, toAdapter, fromAdapter));
        } else {
            this.adapters.add(new ReactiveAdapter(descriptor, toAdapter, fromAdapter));
        }
    }

    @Nullable
    public ReactiveAdapter getAdapter(Class<?> reactiveType) {
        return this.getAdapter(reactiveType, null);
    }

    @Nullable
    public ReactiveAdapter getAdapter(@Nullable Class<?> reactiveType, @Nullable Object source) {
        Class<?> clazz;
        if (this.adapters.isEmpty()) {
            return null;
        }
        if (source instanceof Optional) {
            Optional optional = (Optional)source;
            source = optional.orElse(null);
        }
        Class<?> clazz2 = clazz = source != null ? source.getClass() : reactiveType;
        if (clazz == null) {
            return null;
        }
        for (ReactiveAdapter adapter : this.adapters) {
            if (adapter.getReactiveType() != clazz) continue;
            return adapter;
        }
        for (ReactiveAdapter adapter : this.adapters) {
            if (!adapter.getReactiveType().isAssignableFrom(clazz)) continue;
            return adapter;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReactiveAdapterRegistry getSharedInstance() {
        ReactiveAdapterRegistry registry = sharedInstance;
        if (registry != null) return registry;
        Class<ReactiveAdapterRegistry> clazz = ReactiveAdapterRegistry.class;
        synchronized (ReactiveAdapterRegistry.class) {
            registry = sharedInstance;
            if (registry != null) return registry;
            sharedInstance = registry = new ReactiveAdapterRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return registry;
        }
    }

    private static boolean isPresent(String className) {
        return ClassUtils.isPresent(className, ReactiveAdapterRegistry.class.getClassLoader());
    }

    static {
        mutinyPresent = ReactiveAdapterRegistry.isPresent("io.smallrye.mutiny.Multi");
        reactorPresent = ReactiveAdapterRegistry.isPresent("reactor.core.publisher.Flux");
        rxjava3Present = ReactiveAdapterRegistry.isPresent("io.reactivex.rxjava3.core.Flowable");
    }

    private static class ReactorRegistrar {
        private static final Flow.Publisher<?> EMPTY_FLOW = JdkFlowAdapter.publisherToFlowPublisher((Publisher)Flux.empty());

        private ReactorRegistrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry registry) {
            registry.registerReactiveType(ReactiveTypeDescriptor.singleOptionalValue(Mono.class, Mono::empty), source -> (Mono)source, Mono::from);
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flux.class, Flux::empty), source -> (Flux)source, Flux::from);
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Publisher.class, Flux::empty), source -> (Publisher)source, source -> source);
            registry.registerReactiveType(ReactiveTypeDescriptor.nonDeferredAsyncValue(CompletionStage.class, EmptyCompletableFuture::new), source -> Mono.fromCompletionStage((CompletionStage)((CompletionStage)source)), source -> Mono.from((Publisher)source).toFuture());
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flow.Publisher.class, () -> EMPTY_FLOW), source -> JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)((Flow.Publisher)source)), JdkFlowAdapter::publisherToFlowPublisher);
        }
    }

    private static class RxJava3Registrar {
        private RxJava3Registrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry registry) {
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Flowable.class, Flowable::empty), source -> (Flowable)source, Flowable::fromPublisher);
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Observable.class, Observable::empty), source -> ((Observable)source).toFlowable(BackpressureStrategy.BUFFER), Observable::fromPublisher);
            registry.registerReactiveType(ReactiveTypeDescriptor.singleRequiredValue(Single.class), source -> ((Single)source).toFlowable(), Single::fromPublisher);
            registry.registerReactiveType(ReactiveTypeDescriptor.singleOptionalValue(Maybe.class, Maybe::empty), source -> ((Maybe)source).toFlowable(), Maybe::fromPublisher);
            registry.registerReactiveType(ReactiveTypeDescriptor.noValue(Completable.class, Completable::complete), source -> ((Completable)source).toFlowable(), Completable::fromPublisher);
        }
    }

    private static class MutinyRegistrar {
        private MutinyRegistrar() {
        }

        void registerAdapters(ReactiveAdapterRegistry registry) {
            registry.registerReactiveType(ReactiveTypeDescriptor.singleOptionalValue(Uni.class, () -> Uni.createFrom().nothing()), uni -> ((Uni)uni).convert().toPublisher(), publisher -> Uni.createFrom().publisher(publisher));
            registry.registerReactiveType(ReactiveTypeDescriptor.multiValue(Multi.class, () -> Multi.createFrom().empty()), multi -> (Multi)multi, publisher -> Multi.createFrom().publisher(publisher));
        }
    }

    private static class ReactorAdapter
    extends ReactiveAdapter {
        ReactorAdapter(ReactiveTypeDescriptor descriptor, Function<Object, Publisher<?>> toPublisherFunction, Function<Publisher<?>, Object> fromPublisherFunction) {
            super(descriptor, toPublisherFunction, fromPublisherFunction);
        }

        @Override
        public <T> Publisher<T> toPublisher(@Nullable Object source) {
            Publisher publisher = super.toPublisher(source);
            return this.isMultiValue() ? Flux.from(publisher) : Mono.from(publisher);
        }
    }

    public static class CoreBlockHoundIntegration
    implements BlockHoundIntegration {
        public void applyTo(BlockHound.Builder builder) {
            builder.allowBlockingCallsInside("cn.taketoday.core.LocalVariableTableParameterNameDiscoverer", "inspectClass");
            String className = "cn.taketoday.util.ConcurrentReferenceHashMap$Segment";
            builder.allowBlockingCallsInside(className, "doTask");
            builder.allowBlockingCallsInside(className, "clear");
            builder.allowBlockingCallsInside(className, "restructure");
        }
    }

    private static class EmptyCompletableFuture<T>
    extends CompletableFuture<T> {
        EmptyCompletableFuture() {
            this.complete(null);
        }
    }
}

