/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ExceptionUtils;

public abstract class NestedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public NestedRuntimeException() {
    }

    public NestedRuntimeException(@Nullable String msg) {
        super(msg);
    }

    public NestedRuntimeException(@Nullable Throwable cause) {
        super(cause);
    }

    public NestedRuntimeException(@Nullable String msg, @Nullable Throwable cause) {
        super(msg, cause);
    }

    public String getNestedMessage() {
        return ExceptionUtils.buildMessage(this.getMessage(), this.getCause());
    }

    @Nullable
    public Throwable getRootCause() {
        return ExceptionUtils.getRootCause(this);
    }

    public Throwable getMostSpecificCause() {
        Throwable rootCause = this.getRootCause();
        return rootCause != null ? rootCause : this;
    }

    public boolean contains(@Nullable Class<?> exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause == this) {
            return false;
        }
        if (cause instanceof NestedRuntimeException) {
            return ((NestedRuntimeException)cause).contains(exType);
        }
        while (cause != null) {
            if (exType.isInstance(cause)) {
                return true;
            }
            if (cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }

    static {
        ExceptionUtils.class.getName();
    }
}

